package br.ufrgs.inf.prosoft.tigris.sampling;

import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FrequencyDataSet {

    private Map<Granularity, Integer> granularityPopulation = new HashMap<>();
    private long n;

    public void addItem(Granularity item) {
        if (granularityPopulation.containsKey(item)){
            granularityPopulation.put(item, granularityPopulation.get(item) + 1);
        }
        else {
            granularityPopulation.put(item, 1);
        }
        n++;
    }

    public long getTotalItems(){
        return n;
    }

    public double getProportion(Granularity granularity){
        Integer occurrences = granularityPopulation.get(granularity);
        if (occurrences == null)
            return 0;
        return occurrences / getTotalItems();
    }

    public Set<Granularity> getGranularities(){
        return granularityPopulation.keySet();
    }

    public SummaryStatistics getAsDescriptiveStatistics(){
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        for (Map.Entry<Granularity, Integer> populationEntry : granularityPopulation.entrySet()) {
            summaryStatistics.addValue(populationEntry.getValue());
        }
        return summaryStatistics;
    }

    public Map<Granularity, Integer> getTraceFrequency() {
        return granularityPopulation;
    }
}
