/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle.output;

import ca.uqac.lif.bullwinkle.CaptureBlockParseNode;
import ca.uqac.lif.bullwinkle.ParseNode;
import ca.uqac.lif.bullwinkle.output.OutputFormatVisitor;
import java.util.ArrayDeque;
import java.util.Deque;

public class GraphvizVisitor
implements OutputFormatVisitor {
    private Deque<Integer> m_parents = new ArrayDeque<Integer>();
    private int m_nodeCount = 0;
    private StringBuilder m_output = new StringBuilder();

    @Override
    public void visit(ParseNode node) {
        int cur_node = this.m_nodeCount++;
        if (!this.m_parents.isEmpty()) {
            int parent = this.m_parents.peek();
            this.m_output.append(parent).append(" -> ").append(cur_node).append(";\n");
        }
        String shape = "oval";
        if (node instanceof CaptureBlockParseNode) {
            shape = "rectangle";
        }
        String color = "white";
        String fillcolor = "blue";
        String label = GraphvizVisitor.escape(node.getValue());
        if (label == null) {
            label = GraphvizVisitor.escape(node.getToken());
            shape = "rect";
            fillcolor = "white";
            color = "black";
        }
        this.m_output.append("  ").append(cur_node).append(" [fontcolor=\"").append(color).append("\",style=\"filled\",fillcolor=\"").append(fillcolor).append("\",shape=\"").append(shape).append("\",label=\"").append(label).append("\"];\n");
        this.m_parents.push(cur_node);
    }

    @Override
    public void pop() {
        this.m_parents.pop();
    }

    @Override
    public String toOutputString() {
        StringBuilder out = new StringBuilder();
        out.append("# File auto-generated by Bullwinkle\n\n");
        out.append("digraph G {\n").append((CharSequence)this.m_output).append("}");
        return out.toString();
    }

    private static String escape(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("\\\"", "&quot;");
    }
}

