package br.ufrgs.inf.prosoft.tigris.monitoring.storage.providers;

import br.ufrgs.inf.prosoft.tigris.exceptions.StorageException;
import br.ufrgs.inf.prosoft.tigris.monitoring.storage.Repository;

import java.util.List;

/**
 * The type Console repository.
 *
 * @param <T> the type parameter
 */
public class ConsoleRepository<T> implements Repository<T> {


    @Override
    public void save(T t) throws StorageException {
        System.out.println("Saving to console: " + t.toString());
    }

    @Override
    public List<T> findAll() {
        return null;
    }

    @Override
    public void removeAll() {

    }

    @Override
    public void saveAll(List<T> toSave) {
        for(T t : toSave){
            System.out.println("Saving to console: " + t.toString());
        }
    }
}
