package br.ufrgs.inf.prosoft.tigris.monitoring.storage.providers;

import br.ufrgs.inf.prosoft.tigris.monitoring.storage.Repository;
import org.redisson.Redisson;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;

import java.util.List;

/**
 * The type Redis repository.
 *
 * @param <T> the type parameter
 */
public class RedisRepository<T> implements Repository<T> {

    private final RedissonClient redisson;
    private final RList<T> traces;

    /**
     * Instantiates a new Redis repository.
     */
    public RedisRepository(){
        redisson = Redisson.create();
        traces = redisson.getList("tracer");
    }

    @Override
    public void save(T t) {
        traces.add(t);
    }

    @Override
    public List<T> findAll() {
        return traces.readAll();
    }

    @Override
    public void removeAll() {
        traces.clearExpireAsync();
    }

    @Override
    public void saveAll(List<T> toSave) {
        traces.addAll(toSave);
    }
}
