/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.util;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CliParser {
    protected Set<Argument> m_arguments = new HashSet<Argument>();

    public void addArgument(Argument a) {
        this.m_arguments.add(a);
    }

    public ArgumentMap parse(String[] cli) {
        ArgumentMap parsed = new ArgumentMap();
        Argument current_argument = null;
        String current_value = "";
        int i = 0;
        while (i < cli.length) {
            String argument = cli[i];
            if (argument.startsWith("-")) {
                String arg_name = "";
                arg_name = argument.startsWith("--") ? argument.substring(2) : argument.substring(1);
                if (arg_name.isEmpty()) {
                    return null;
                }
                if (current_argument == null && !current_value.isEmpty()) {
                    parsed.putOther(arg_name);
                    current_value = "";
                } else {
                    boolean r_val = this.handleEndOfArgument(current_argument, current_value, parsed);
                    if (!r_val) {
                        return null;
                    }
                    current_value = "";
                    current_argument = this.findArgument(arg_name);
                    if (current_argument == null) {
                        return null;
                    }
                }
            } else if (current_value.isEmpty()) {
                if (current_argument != null && current_argument.m_valueName == null) {
                    boolean r_val = this.handleEndOfArgument(current_argument, current_value, parsed);
                    if (!r_val) {
                        return null;
                    }
                    current_argument = null;
                }
                current_value = argument;
            } else {
                boolean r_val = this.handleEndOfArgument(current_argument, current_value, parsed);
                if (!r_val) {
                    return null;
                }
                current_argument = null;
                current_value = argument;
            }
            ++i;
        }
        boolean r_val = this.handleEndOfArgument(current_argument, current_value, parsed);
        if (!r_val) {
            return null;
        }
        return parsed;
    }

    private boolean handleEndOfArgument(Argument current_argument, String current_value, ArgumentMap parsed) {
        if (current_argument != null) {
            if (current_argument.m_valueName != null && current_value.isEmpty()) {
                return false;
            }
            if (current_argument.m_longName != null) {
                parsed.put(current_argument.m_longName, current_value);
            } else {
                parsed.put(current_argument.m_shortName, current_value);
            }
        } else if (!current_value.isEmpty()) {
            parsed.putOther(current_value);
        }
        return true;
    }

    private Argument findArgument(String name) {
        for (Argument arg : this.m_arguments) {
            if (arg.m_shortName != null && arg.m_shortName.compareTo(name) == 0) {
                return arg;
            }
            if (arg.m_longName == null || arg.m_longName.compareTo(name) != 0) continue;
            return arg;
        }
        return null;
    }

    public void printHelp(String header, PrintStream out) {
        StringBuilder output = new StringBuilder();
        output.append(header).append("\n\n");
        for (Argument arg : this.m_arguments) {
            if (arg.m_shortName != null) {
                output.append("-").append(arg.m_shortName).append(" ");
            }
            if (arg.m_longName != null) {
                output.append("--").append(arg.m_longName).append(" ");
            }
            if (arg.m_valueName != null) {
                output.append(arg.m_valueName);
            }
            if (arg.m_description != null) {
                output.append("\t").append(arg.m_description);
            }
            output.append("\n");
        }
        out.print(output);
    }

    public static class Argument {
        String m_valueName = null;
        String m_shortName = null;
        String m_longName = null;
        String m_description = null;

        public Argument withShortName(String name) {
            this.m_shortName = name;
            return this;
        }

        public Argument withLongName(String name) {
            this.m_longName = name;
            return this;
        }

        public Argument withDescription(String description) {
            this.m_description = description;
            return this;
        }

        public Argument withArgument(String name) {
            this.m_valueName = name;
            return this;
        }

        public int hashCode() {
            if (this.m_shortName == null) {
                return 0;
            }
            return this.m_shortName.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Argument)) {
                return false;
            }
            Argument a = (Argument)o;
            return this.m_shortName != null && a.m_shortName != null && this.m_shortName.compareTo(a.m_shortName) == 0 || this.m_longName != null && a.m_longName != null && this.m_longName.compareTo(a.m_longName) == 0;
        }

        public String toString() {
            if (this.m_longName != null) {
                return this.m_longName;
            }
            if (this.m_shortName != null) {
                return this.m_shortName;
            }
            return "";
        }
    }

    public static class ArgumentMap
    implements Map<String, String> {
        private final Map<String, String> m_arguments = new HashMap<String, String>();
        private final List<String> m_others = new LinkedList<String>();

        public boolean hasOption(String name) {
            return this.m_arguments.containsKey(name);
        }

        public String getOptionValue(String name) {
            if (this.m_arguments.containsKey(name)) {
                return this.m_arguments.get(name);
            }
            return null;
        }

        public List<String> getOthers() {
            return this.m_others;
        }

        @Override
        public String put(String name, String value) {
            return this.m_arguments.put(name, value);
        }

        public boolean putOther(String name) {
            return this.m_others.add(name);
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append(this.m_arguments).append(",").append(this.m_others);
            return out.toString();
        }

        @Override
        public int size() {
            return this.m_arguments.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m_arguments.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m_arguments.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m_arguments.containsValue(value);
        }

        @Override
        public String get(Object key) {
            return this.m_arguments.get(key);
        }

        @Override
        public String remove(Object key) {
            return this.m_arguments.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.m_arguments.putAll(m);
            if (m instanceof ArgumentMap) {
                this.m_others.addAll(((ArgumentMap)m).getOthers());
            }
        }

        @Override
        public void clear() {
            this.m_arguments.clear();
            this.m_others.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.m_arguments.keySet();
        }

        @Override
        public Collection<String> values() {
            return this.m_arguments.values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.m_arguments.entrySet();
        }
    }
}

