package br.ufrgs.inf.prosoft.tigris.sampling;

import java.util.Objects;

public class Granularity {

    public GranularityType granularityType;
    public String name;

    public Granularity(GranularityType granularityType, String name) {
        this.granularityType = granularityType;
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Granularity that = (Granularity) o;
        return granularityType == that.granularityType &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(granularityType, name);
    }

    @Override
    public String toString() {
        return "Granularity{" +
                "granularityType=" + granularityType +
                ", name='" + name + '\'' +
                '}';
    }
}
