/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle;

import ca.uqac.lif.bullwinkle.BnfRule;
import ca.uqac.lif.bullwinkle.CaptureBlockParseNode;
import ca.uqac.lif.bullwinkle.EpsilonTerminalToken;
import ca.uqac.lif.bullwinkle.NonTerminalToken;
import ca.uqac.lif.bullwinkle.ParseNode;
import ca.uqac.lif.bullwinkle.RegexTerminalToken;
import ca.uqac.lif.bullwinkle.TerminalToken;
import ca.uqac.lif.bullwinkle.Token;
import ca.uqac.lif.bullwinkle.TokenString;
import ca.uqac.lif.util.EmptyException;
import ca.uqac.lif.util.MutableString;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BnfParser
implements Serializable {
    private static final transient long serialVersionUID = 1L;
    private LinkedList<BnfRule> m_rules;
    private BnfRule m_startRule;
    private transient boolean m_debugMode = false;
    private transient Logger m_debugOut = Logger.getAnonymousLogger();
    private transient int m_maxRecursionSteps = 50;
    private boolean m_partialParsing = false;

    public BnfParser() {
        this.m_startRule = null;
        this.m_rules = new LinkedList();
    }

    public BnfParser(BnfParser parser) {
        this.m_rules = new LinkedList();
        this.m_rules.addAll(parser.m_rules);
        this.m_startRule = parser.m_startRule;
    }

    public BnfParser(InputStream is) throws InvalidGrammarException {
        this();
        Scanner s = new Scanner(is);
        this.setGrammar(s);
    }

    public void setPartialParsing(boolean b) {
        this.m_partialParsing = b;
    }

    public static void setCaseSensitive(boolean b) {
        Token.setCaseSensitive(b);
    }

    public void setMaxRecursionSteps(int steps) {
        if (steps > 0) {
            this.m_maxRecursionSteps = steps;
        }
    }

    public void setDebugMode(boolean b) {
        this.m_debugMode = b;
    }

    public void setDebugMode(boolean b, Logger out) {
        this.m_debugMode = b;
        this.m_debugOut = out;
    }

    public BnfRule getStartRule() {
        return this.m_startRule;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (BnfRule rule : this.m_rules) {
            out.append(rule).append(";\n");
        }
        return out.toString();
    }

    public void addCaseToRule(int index, String rule_name, String case_string) {
        BnfRule rule = this.getRule(rule_name);
        if (rule == null) {
            return;
        }
        NonTerminalToken ntok = new NonTerminalToken(case_string);
        TokenString ts = new TokenString();
        ts.add(ntok);
        rule.addAlternative(index, ts);
    }

    public void addCaseToRule(String rule_name, String case_string) {
        this.addCaseToRule(0, rule_name, case_string);
    }

    public BnfRule getRule(String rule_name) {
        for (BnfRule rule : this.m_rules) {
            String lhs = rule.getLeftHandSide().getName();
            if (rule_name.compareTo(lhs) != 0) continue;
            return rule;
        }
        return null;
    }

    public void setGrammar(String grammar) throws InvalidGrammarException {
        List<BnfRule> rules = BnfParser.getRules(grammar);
        this.addRules(rules);
    }

    public void setGrammar(Scanner scanner) throws InvalidGrammarException {
        List<BnfRule> rules = BnfParser.getRules(scanner);
        this.addRules(rules);
    }

    public static List<BnfRule> getRules(String grammar) throws InvalidGrammarException {
        if (grammar == null) {
            throw new InvalidGrammarException("Null argument given");
        }
        Scanner s = new Scanner(grammar);
        return BnfParser.getRules(s);
    }

    public static List<BnfRule> getRules(Scanner scanner) throws InvalidGrammarException {
        LinkedList<BnfRule> rules = new LinkedList<BnfRule>();
        StringBuilder current_rule_builder = new StringBuilder();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            current_rule_builder.append(" ").append(line);
            if (!line.endsWith(";")) continue;
            String current_rule = current_rule_builder.toString();
            try {
                current_rule = current_rule.trim();
                BnfRule new_rule = BnfRule.parseRule(current_rule.substring(0, current_rule.length() - 1));
                rules.add(new_rule);
            }
            catch (BnfRule.InvalidRuleException e) {
                scanner.close();
                throw new InvalidGrammarException(e);
            }
            current_rule_builder.setLength(0);
        }
        scanner.close();
        if (!current_rule_builder.toString().isEmpty()) {
            throw new InvalidGrammarException("Error parsing rule " + current_rule_builder.toString());
        }
        return rules;
    }

    public List<String> getAlternatives(String rule_name) {
        for (BnfRule rule : this.m_rules) {
            String lhs = rule.getLeftHandSide().getName();
            if (rule_name.compareTo(lhs) != 0) continue;
            ArrayList<String> alternatives = new ArrayList<String>();
            for (TokenString alt : rule.getAlternatives()) {
                alternatives.add(alt.toString());
            }
            return alternatives;
        }
        return new ArrayList<String>(0);
    }

    public void addRule(int position, BnfRule rule) {
        NonTerminalToken r_left = rule.getLeftHandSide();
        for (BnfRule in_rule : this.m_rules) {
            NonTerminalToken in_left = in_rule.getLeftHandSide();
            if (!r_left.equals(in_left)) continue;
            in_rule.addAlternatives(position, rule.getAlternatives());
            break;
        }
        this.m_rules.add(rule);
    }

    public void addRule(BnfRule rule) {
        NonTerminalToken r_left = rule.getLeftHandSide();
        for (BnfRule in_rule : this.m_rules) {
            NonTerminalToken in_left = in_rule.getLeftHandSide();
            if (!r_left.equals(in_left)) continue;
            in_rule.addAlternatives(rule.getAlternatives());
            break;
        }
        this.m_rules.add(rule);
    }

    public void addRules(Collection<BnfRule> rules) {
        for (BnfRule rule : rules) {
            this.addRule(rule);
        }
    }

    public void setStartRule(String tokenName) {
        NonTerminalToken ntok = new NonTerminalToken(tokenName);
        this.setStartRule(ntok);
    }

    public void setStartRule(NonTerminalToken token) {
        this.m_startRule = this.getRule(token);
    }

    public ParseNode parse(String input) throws ParseException {
        MutableString n_input = new MutableString(input);
        if (this.m_startRule == null) {
            if (this.m_rules.isEmpty()) {
                throw new ParseException("No start rule could be found");
            }
            this.m_startRule = this.m_rules.peekFirst();
        }
        return this.parse(this.m_startRule, n_input, 0);
    }

    private ParseNode parse(BnfRule rule, MutableString input, int level) throws ParseException {
        if (level > this.m_maxRecursionSteps) {
            throw new ParseException("Maximum number of recursion steps reached. If the input string is indeed valid, try increasing the limit.");
        }
        ParseNode out_node = null;
        MutableString n_input = new MutableString(input);
        boolean wrong_symbol = true;
        boolean read_epsilon = false;
        this.log("Considering input '" + input + "' with rule " + rule, level);
        for (TokenString alt : rule.getAlternatives()) {
            this.log("Alternative " + alt, level);
            out_node = new ParseNode();
            NonTerminalToken left_hand_side = rule.getLeftHandSide();
            out_node.setToken(left_hand_side.toString());
            out_node.setValue(left_hand_side.toString());
            TokenString new_alt = alt.getCopy();
            Iterator alt_it = new_alt.iterator();
            n_input = new MutableString(input);
            wrong_symbol = false;
            while (alt_it.hasNext() && !wrong_symbol) {
                n_input.trim();
                Token alt_tok = (Token)alt_it.next();
                if (alt_tok instanceof TerminalToken) {
                    if (alt_tok instanceof EpsilonTerminalToken) {
                        ParseNode child = new ParseNode();
                        child.setToken("");
                        out_node.addChild(child);
                        read_epsilon = true;
                        break;
                    }
                    if (n_input.isEmpty()) {
                        wrong_symbol = true;
                        break;
                    }
                    int match_prefix_size = alt_tok.match(n_input.toString());
                    if (match_prefix_size > 0) {
                        ParseNode child = new ParseNode();
                        MutableString input_tok = n_input.truncateSubstring(0, match_prefix_size);
                        if (alt_tok instanceof RegexTerminalToken) {
                            child = BnfParser.appendRegexChildren(child, (RegexTerminalToken)alt_tok, input_tok);
                        }
                        child.setToken(input_tok.toString());
                        out_node.addChild(child);
                        continue;
                    }
                    wrong_symbol = true;
                    out_node = null;
                    this.log("FAILED parsing with case " + new_alt, level);
                    break;
                }
                ParseNode child = null;
                String alt_tok_string = alt_tok.toString();
                if (this.m_partialParsing && n_input.startsWith(alt_tok_string)) {
                    n_input.truncateSubstring(0, alt_tok_string.length());
                    child = new ParseNode(alt_tok_string);
                } else {
                    BnfRule new_rule = this.getRule(alt_tok);
                    if (new_rule == null) {
                        throw new ParseException("Cannot find rule for token " + alt_tok);
                    }
                    child = this.parse(new_rule, n_input, level + 1);
                    if (child == null) {
                        wrong_symbol = true;
                        out_node = null;
                        this.log("FAILED parsing input " + input + " with rule " + rule, level);
                        break;
                    }
                }
                out_node.addChild(child);
            }
            if (wrong_symbol) continue;
            if (!alt_it.hasNext()) {
                if (level <= 0 && (level != 0 || n_input.toString().trim().length() != 0)) continue;
                break;
            }
            wrong_symbol = true;
            n_input = new MutableString(input);
            this.log("No symbols left in input; will explore next alternative", level);
            break;
        }
        int chars_consumed = input.length() - n_input.length();
        if (wrong_symbol) {
            this.log("FAILED: expected more symbols with rule " + rule, level);
            return null;
        }
        if (chars_consumed == 0 && !read_epsilon) {
            this.log("FAILED: did not consume anything of " + input + " with rule " + rule, level);
            return null;
        }
        input.truncateSubstring(chars_consumed);
        if (level == 0 && !input.isEmpty()) {
            this.log("FAILED: The top-level rule must parse the complete string", level);
            return null;
        }
        return out_node;
    }

    private BnfRule getRule(Token tok) {
        if (tok == null) {
            return null;
        }
        for (BnfRule rule : this.m_rules) {
            NonTerminalToken lhs = rule.getLeftHandSide();
            if (lhs == null || lhs.toString().compareTo(tok.toString()) != 0) continue;
            return rule;
        }
        return null;
    }

    public Set<TerminalToken> getTerminalTokens() {
        HashSet<TerminalToken> out = new HashSet<TerminalToken>();
        for (BnfRule rule : this.m_rules) {
            out.addAll(rule.getTerminalTokens());
        }
        return out;
    }

    private void log(String message, int level) {
        StringBuilder out = new StringBuilder();
        if (this.m_debugMode) {
            int i = 0;
            while (i < level) {
                out.append("  ");
                ++i;
            }
            out.append(message);
            this.m_debugOut.log(Level.INFO, "{0}", out.toString());
        }
    }

    protected static ParseNode appendRegexChildren(ParseNode node, RegexTerminalToken tok, MutableString s) {
        List<String> blocks = tok.getCaptureBlocks(s.toString());
        for (String block : blocks) {
            CaptureBlockParseNode pn = new CaptureBlockParseNode(block);
            node.addChild(pn);
        }
        return node;
    }

    public static class InvalidGrammarException
    extends EmptyException {
        private static final transient long serialVersionUID = 1L;

        public InvalidGrammarException(String message) {
            super(message);
        }

        public InvalidGrammarException(Throwable t) {
            super(t);
        }
    }

    public static class ParseException
    extends EmptyException {
        private static final transient long serialVersionUID = 2L;

        public ParseException(String message) {
            super(message);
        }
    }
}

