/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle;

import ca.uqac.lif.bullwinkle.ParseNode;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NodePath
implements Serializable {
    private static final transient long serialVersionUID = 1L;
    protected static transient Pattern s_pattern = Pattern.compile("(.+)(\\[(\\d+)\\]){0,1}");

    private NodePath() {
    }

    public static ParseNode getPathFirst(ParseNode n, String path) {
        List<ParseNode> out = NodePath.getPath(n, path);
        if (!out.isEmpty()) {
            return out.get(0);
        }
        return null;
    }

    public static List<ParseNode> getPath(ParseNode n, String path) {
        String[] path_parts = path.split("\\.");
        LinkedList<String> path_list = new LinkedList<String>();
        String[] stringArray = path_parts;
        int n2 = path_parts.length;
        int n3 = 0;
        while (n3 < n2) {
            String part = stringArray[n3];
            path_list.add(part);
            ++n3;
        }
        ParseNode new_root = new ParseNode();
        new_root.addChild(n);
        return NodePath.getPath(new_root, path_list);
    }

    protected static List<ParseNode> getPath(ParseNode n, List<String> path) {
        LinkedList<ParseNode> out = new LinkedList<ParseNode>();
        if (path.isEmpty()) {
            out.add(n);
            return out;
        }
        if (path.size() == 1 && path.get(0).compareTo("*") == 0) {
            out.addAll(n.getChildren());
            return out;
        }
        String path_el = path.get(0);
        Matcher mat = s_pattern.matcher(path_el);
        if (!mat.find()) {
            return out;
        }
        String el_name = mat.group(1);
        String el_card_s = mat.group(3);
        int el_card = 0;
        if (el_card_s != null) {
            el_card = Integer.parseInt(el_card_s);
        }
        List<ParseNode> children = n.getChildren();
        int i = 0;
        for (ParseNode child : children) {
            if (el_name.compareTo(child.getToken()) != 0) continue;
            if (el_card < 0 || el_card == i) {
                LinkedList<String> new_path = new LinkedList<String>(path);
                new_path.removeFirst();
                List<ParseNode> new_nodes = NodePath.getPath(child, new_path);
                out.addAll(new_nodes);
            }
            ++i;
        }
        return out;
    }
}

