package br.ufrgs.inf.prosoft.tigris;

import br.ufrgs.inf.prosoft.tigris.sampling.Granularity;
import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;
import br.ufrgs.inf.prosoft.tigris.sampling.Sampling;
import org.junit.Assert;
import org.junit.Test;

public class SamplingTest {

    @Test
    public void samplingDecisionWithNoChance(){
        Sampling sampling = new Sampling(0, 100, false);
        for (int i = 0; i < 2000; i++) {
            Assert.assertFalse(sampling.samplingDecision(new Granularity(GranularityType.METHOD, "function")));
        }
        Assert.assertEquals(0, sampling.getSample().getTotalItems());
        Assert.assertEquals(2000, sampling.getPopulation().getTotalItems());
    }

    @Test
    public void samplingDecisionWith100Chance(){
        Sampling sampling = new Sampling(1, 100, false);
        for (int i = 0; i < 2000; i++) {
            Assert.assertTrue(sampling.samplingDecision(new Granularity(GranularityType.METHOD, "function")));
        }
        Assert.assertEquals(2000, sampling.getSample().getTotalItems());
        Assert.assertEquals(2000, sampling.getPopulation().getTotalItems());
    }
}
