
package br.ufrgs.inf.prosoft.tigris.utils;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.inference.TestUtils;

/**
 * The type Statistical test.
 */
public class StatisticalTest {

    /**
     * Is normal distribution boolean.
     *
     * @param sample            the sample
     * @param significanceLevel the significance level
     * @return the boolean
     */
    public static boolean isNormalDistribution(double[] sample, double significanceLevel){
        final NormalDistribution unitNormal = new NormalDistribution(0d, 1d);

        //alpha significance level (equiv. 100 * (1-alpha)% confidence) where 0 < alpha < 1 use
        //Significance level of 95%: 100 * (1-0.05)

        //the test below compares p-value < alpha = 0.05
        //As a rule of thumb, we reject the null hypothesis if p < 0.05.
        //So if p < 0.05, we don't believe that our variable follows a normal distribution in our population.
        return !TestUtils.kolmogorovSmirnovTest(unitNormal, sample, significanceLevel);
    }
}
