/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle.output;

import ca.uqac.lif.bullwinkle.ParseNode;
import ca.uqac.lif.bullwinkle.output.OutputFormatVisitor;
import java.util.ArrayDeque;
import java.util.Deque;

public class IndentedTextVisitor
implements OutputFormatVisitor {
    private Deque<String> m_indents = new ArrayDeque<String>();
    private StringBuilder m_output = new StringBuilder();
    private static final String s_indent = " ";

    public IndentedTextVisitor() {
        this.m_indents.push("");
    }

    @Override
    public void visit(ParseNode node) {
        String label = node.getValue();
        String current_indent = String.valueOf(this.m_indents.peek()) + s_indent;
        if (label == null) {
            label = node.getToken();
            this.m_indents.push(current_indent);
            current_indent = this.m_indents.peek();
            this.m_output.append(current_indent).append(label).append("\n");
        } else {
            this.m_output.append(current_indent).append(label).append("\n");
            this.m_indents.push(current_indent);
        }
    }

    @Override
    public void pop() {
        this.m_indents.pop();
    }

    @Override
    public String toOutputString() {
        return this.m_output.toString();
    }
}

