package br.ufrgs.inf.prosoft.tigris.sampling;

public class MonitoringCycle {
    private double averageProcTimesSample;
    private double stdProcTimesSample;
    private double averageProcTimesPopulation;
    private double stdProcTimesPopulation;
    private long sampleSize;
    private long populationSize;
    private long monitoringCycleTime;

    public MonitoringCycle(FrequencyDataSet sample, FrequencyDataSet population, long monitoringCycleTime) {
        this.averageProcTimesSample = sample.getMeanExecutionTime();
        this.stdProcTimesSample = sample.getStdExecutionTime();
        this.sampleSize = sample.getTotalItems();

        this.averageProcTimesPopulation = population.getMeanExecutionTime();
        this.stdProcTimesPopulation = population.getStdExecutionTime();
        this.populationSize = population.getTotalItems();
        this.monitoringCycleTime = monitoringCycleTime;
    }

    public MonitoringCycle() {
        this.averageProcTimesSample = 0;
        this.stdProcTimesSample = 0;
        this.sampleSize = 0;
        this.averageProcTimesPopulation = 0;
        this.stdProcTimesPopulation = 0;
        this.populationSize = 0;
        this.monitoringCycleTime = 0;
    }

    public long getMonitoringCycleTime() {
        return monitoringCycleTime;
    }

    @Override
    public String toString() {
        return "MonitoringCycle{" +
                "averageProcTimesSample=" + averageProcTimesSample +
                ", stdProcTimesSample=" + stdProcTimesSample +
                ", averageProcTimesPopulation=" + averageProcTimesPopulation +
                ", stdProcTimesPopulation=" + stdProcTimesPopulation +
                ", sampleSize=" + sampleSize +
                ", populationSize=" + populationSize +
                ", monitoringCycleTime=" + monitoringCycleTime +
                '}';
    }

    public double getStdProcTimesSample() {
        return stdProcTimesSample;
    }

    public double getStdProcTimesPopulation() {
        return stdProcTimesPopulation;
    }

    public double getAverageProcTimesSample() {
        return averageProcTimesSample;
    }

    public double getAverageProcTimesPopulation() {
        return averageProcTimesPopulation;
    }

    public long getSampleSize() {
        return sampleSize;
    }

    public long getPopulationSize() {
        return populationSize;
    }
}
