/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.ifelse.AndOperation;
import org.jboss.as.cli.handlers.ifelse.BaseOperation;
import org.jboss.as.cli.handlers.ifelse.ComparisonOperation;
import org.jboss.as.cli.handlers.ifelse.EqualsOperation;
import org.jboss.as.cli.handlers.ifelse.GreaterThanOperation;
import org.jboss.as.cli.handlers.ifelse.LesserThanOperation;
import org.jboss.as.cli.handlers.ifelse.ModelNodePathOperand;
import org.jboss.as.cli.handlers.ifelse.NotEqualsOperation;
import org.jboss.as.cli.handlers.ifelse.NotGreaterThanOperation;
import org.jboss.as.cli.handlers.ifelse.NotLesserThanOperation;
import org.jboss.as.cli.handlers.ifelse.Operand;
import org.jboss.as.cli.handlers.ifelse.Operation;
import org.jboss.as.cli.handlers.ifelse.OrOperation;
import org.jboss.as.cli.handlers.ifelse.StringValueOperand;

public class ExpressionParser {
    public static final String AND = "&&";
    public static final String OR = "||";
    public static final String EQ = "==";
    public static final String NOT_EQ = "!=";
    public static final String GT = ">";
    public static final String LT = "<";
    public static final String NLT = ">=";
    public static final String NGT = "<=";
    private String input;
    private int pos;
    private BaseOperation lookedAheadOp;

    public Operation parseExpression(String input) throws CommandLineException {
        String prevInput = this.input;
        int prevPos = this.pos;
        this.input = input;
        this.pos = 0;
        Operation op = null;
        while (!this.isEOL()) {
            op = this.getNextOperationFor(op);
        }
        if (prevInput != null) {
            this.input = prevInput;
            this.pos += prevPos + 2;
        }
        return op;
    }

    public void reset() {
        this.input = null;
        this.pos = 0;
        this.lookedAheadOp = null;
    }

    public Operation getNextOperationFor(Operand firstOperand) throws CommandLineException {
        BaseOperation op;
        if (firstOperand == null && (firstOperand = this.parseOperand()) == null) {
            return null;
        }
        if (this.isEOL()) {
            return (Operation)firstOperand;
        }
        if (this.lookedAheadOp != null) {
            op = this.lookedAheadOp;
            this.lookedAheadOp = null;
        } else {
            op = this.getOperationForPosition();
        }
        op.addOperand(firstOperand);
        while (this.input.startsWith(op.getName(), this.pos) && this.input.length() >= this.pos + op.getName().length()) {
            this.pos += op.getName().length();
            Operand operand = this.parseOperand();
            if (operand == null) {
                return op;
            }
            if (!this.isEOL()) {
                this.lookedAheadOp = this.getOperationForPosition();
                if (this.lookedAheadOp.getPriority() > op.getPriority()) {
                    operand = this.getNextOperationFor(operand);
                }
            }
            op.addOperand(operand);
        }
        return op;
    }

    public boolean isEOL() {
        return this.pos >= this.input.length();
    }

    protected Operand parseOperand() throws CommandLineException {
        Operand operand;
        this.skipWhitespaces();
        if (this.pos == this.input.length()) {
            return null;
        }
        if (this.input.charAt(this.pos) == '(') {
            int depthCount = 0;
            int endIndex = this.pos;
            while (++endIndex < this.input.length()) {
                if (this.input.charAt(endIndex) == '(') {
                    ++depthCount;
                    continue;
                }
                if (this.input.charAt(endIndex) != ')') continue;
                if (depthCount == 0) {
                    Operation expr = this.parseExpression(this.input.substring(this.pos + 1, endIndex));
                    this.skipWhitespaces();
                    return expr;
                }
                --depthCount;
            }
            throw new IllegalStateException("Failed to locate closing ')' for '(' at " + this.pos + " in '" + this.input + "'");
        }
        int start = this.pos;
        int end = this.pos;
        ComparisonOperation comparison = null;
        while (this.pos != this.input.length()) {
            char ch = this.input.charAt(this.pos);
            if (Character.isWhitespace(ch)) {
                this.skipWhitespaces();
                comparison = this.tryComparison();
                break;
            }
            if (ch == '&' || ch == '|' || (comparison = this.tryComparison()) != null) break;
            ++this.pos;
            ++end;
        }
        String op = this.input.substring(start, end);
        if (comparison != null) {
            comparison.addOperand(new ModelNodePathOperand(op));
            operand = comparison;
            comparison.addOperand(this.parseOperand());
        } else {
            operand = new StringValueOperand(op);
        }
        return operand;
    }

    protected ComparisonOperation tryComparison() {
        if (this.pos >= this.input.length()) {
            return null;
        }
        if (this.input.startsWith(EQ, this.pos)) {
            this.pos += 2;
            return new EqualsOperation();
        }
        if (this.input.startsWith(NOT_EQ, this.pos)) {
            this.pos += 2;
            return new NotEqualsOperation();
        }
        if (this.input.charAt(this.pos) == '>') {
            if (this.input.length() > this.pos + 1 && this.input.charAt(this.pos + 1) == '=') {
                this.pos += 2;
                return new NotLesserThanOperation();
            }
            ++this.pos;
            return new GreaterThanOperation();
        }
        if (this.input.charAt(this.pos) == '<') {
            if (this.input.length() > this.pos + 1 && this.input.charAt(this.pos + 1) == '=') {
                this.pos += 2;
                return new NotGreaterThanOperation();
            }
            ++this.pos;
            return new LesserThanOperation();
        }
        return null;
    }

    protected void skipWhitespaces() {
        while (this.pos < this.input.length() && Character.isWhitespace(this.input.charAt(this.pos))) {
            ++this.pos;
        }
    }

    protected BaseOperation getOperationForPosition() {
        if (this.input.startsWith(AND, this.pos)) {
            return new AndOperation();
        }
        if (this.input.startsWith(OR, this.pos)) {
            return new OrOperation();
        }
        throw new IllegalStateException("Unexpected operation at " + this.pos + " in '" + this.input + "'");
    }
}

