/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.command;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.LineBreakHandler;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.as.cli.parsing.command.ArgumentValueState;

public class ArgumentState
extends DefaultParsingState {
    public static final ArgumentState INSTANCE = new ArgumentState();
    public static final String ID = "PROP";

    ArgumentState() {
        this(ArgumentValueState.INSTANCE);
    }

    ArgumentState(ArgumentValueState valueState) {
        super(ID);
        this.setEnterHandler(GlobalCharacterHandlers.CONTENT_CHARACTER_HANDLER);
        final NameValueSeparatorState nvSep = new NameValueSeparatorState(valueState);
        this.enterState('=', nvSep);
        this.setDefaultHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                ctx.resolveExpression(true, true);
                WordCharacterHandler.IGNORE_LB_ESCAPE_ON.handle(ctx);
            }
        });
        this.setWhitespaceHandler(new EnterStateCharacterHandler(new WhitespaceState()));
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    ctx.leaveState();
                } else if (ctx.getCharacter() == '=') {
                    ctx.enterState(nvSep);
                } else {
                    ctx.leaveState();
                }
            }
        });
    }

    private static class NameValueSeparatorState
    extends DefaultParsingState {
        NameValueSeparatorState(final ArgumentValueState valueState) {
            super("NAME_VALUE_SEPARATOR");
            this.setDefaultHandler(new LineBreakHandler(false, false){

                @Override
                protected void doHandle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(valueState);
                }
            });
            this.setReturnHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
            this.setIgnoreWhitespaces(true);
        }
    }

    private static class WhitespaceState
    extends DefaultParsingState {
        public WhitespaceState() {
            super("WS");
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (!Character.isWhitespace(ctx.getCharacter())) {
                        ctx.leaveState();
                    }
                }
            });
        }

        @Override
        public boolean updateValueIndex() {
            return false;
        }
    }
}

