package org.keycloak.models.cache;

import org.keycloak.models.cache.entities.CachedRealm;

/**
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Revision: 1 $
 */
public interface KeycloakCache {
    CachedRealm getCachedRealm(String id);

    void invalidateCachedRealm(CachedRealm realm);

    void addCachedRealm(CachedRealm realm);

    CachedRealm getCachedRealmByName(String name);

    void clear();

    void invalidateCachedRealmById(String id);
}
