/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.keycloak.forms.account.freemarker.model;

/**
 * @author <a href="mailto:sthorger@redhat.com">Stian Thorgersen</a>
 */
public class FeaturesBean {

    private final boolean identityFederation;
    private final boolean log;
    private final boolean passwordUpdateSupported;
    private boolean authorization;

    public FeaturesBean(boolean identityFederation, boolean log, boolean passwordUpdateSupported, boolean authorization) {
        this.identityFederation = identityFederation;
        this.log = log;
        this.passwordUpdateSupported = passwordUpdateSupported;
        this.authorization = authorization;
    }

    public boolean isIdentityFederation() {
        return identityFederation;
    }

    public boolean isLog() {
        return log;
    }

    public boolean isPasswordUpdateSupported() {
        return passwordUpdateSupported;
    }

    public boolean isAuthorization() {
        return authorization;
    }
}
