var isError = require('../lang/isError');

/**
 * Attempts to invoke `func`, returning either the result or the caught
 * error object.
 *
 * @static
 * @memberOf _
 * @category Utility
 * @param {*} func The function to attempt.
 * @returns {*} Returns the `func` result or error object.
 * @example
 *
 * // avoid throwing errors for invalid selectors
 * var elements = _.attempt(function() {
 *   return document.querySelectorAll(selector);
 * });
 *
 * if (_.isError(elements)) {
 *   elements = [];
 * }
 */
function attempt(func) {
  try {
    return func();
  } catch(e) {
    return isError(e) ? e : Error(e);
  }
}

module.exports = attempt;
