'use strict';var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var abstract_change_detector_1 = require('./abstract_change_detector');
var change_detection_util_1 = require('./change_detection_util');
var proto_record_1 = require('./proto_record');
var codegen_name_util_1 = require('./codegen_name_util');
var codegen_logic_util_1 = require('./codegen_logic_util');
var codegen_facade_1 = require('./codegen_facade');
var constants_1 = require('./constants');
var proto_change_detector_1 = require('./proto_change_detector');
/**
 * The code generator takes a list of proto records and creates a function/class
 * that "emulates" what the developer would write by hand to implement the same
 * kind of behaviour.
 *
 * This code should be kept in sync with the Dart transformer's
 * `angular2.transform.template_compiler.change_detector_codegen` library. If you make updates
 * here, please make equivalent changes there.
*/
var IS_CHANGED_LOCAL = "isChanged";
var CHANGES_LOCAL = "changes";
var ChangeDetectorJITGenerator = (function () {
    function ChangeDetectorJITGenerator(definition, changeDetectionUtilVarName, abstractChangeDetectorVarName, changeDetectorStateVarName) {
        this.changeDetectionUtilVarName = changeDetectionUtilVarName;
        this.abstractChangeDetectorVarName = abstractChangeDetectorVarName;
        this.changeDetectorStateVarName = changeDetectorStateVarName;
        var propertyBindingRecords = proto_change_detector_1.createPropertyRecords(definition);
        var eventBindingRecords = proto_change_detector_1.createEventRecords(definition);
        var propertyBindingTargets = definition.bindingRecords.map(function (b) { return b.target; });
        this.id = definition.id;
        this.changeDetectionStrategy = definition.strategy;
        this.genConfig = definition.genConfig;
        this.records = propertyBindingRecords;
        this.propertyBindingTargets = propertyBindingTargets;
        this.eventBindings = eventBindingRecords;
        this.directiveRecords = definition.directiveRecords;
        this._names = new codegen_name_util_1.CodegenNameUtil(this.records, this.eventBindings, this.directiveRecords, this.changeDetectionUtilVarName);
        this._logic =
            new codegen_logic_util_1.CodegenLogicUtil(this._names, this.changeDetectionUtilVarName, this.changeDetectorStateVarName, this.changeDetectionStrategy);
        this.typeName = codegen_name_util_1.sanitizeName("ChangeDetector_" + this.id);
    }
    ChangeDetectorJITGenerator.prototype.generate = function () {
        var factorySource = "\n      " + this.generateSource() + "\n      return function() {\n        return new " + this.typeName + "();\n      }\n    ";
        return new Function(this.abstractChangeDetectorVarName, this.changeDetectionUtilVarName, this.changeDetectorStateVarName, factorySource)(abstract_change_detector_1.AbstractChangeDetector, change_detection_util_1.ChangeDetectionUtil, constants_1.ChangeDetectorState);
    };
    ChangeDetectorJITGenerator.prototype.generateSource = function () {
        return "\n      var " + this.typeName + " = function " + this.typeName + "() {\n        " + this.abstractChangeDetectorVarName + ".call(\n            this, " + JSON.stringify(this.id) + ", " + this.records.length + ",\n            " + this.typeName + ".gen_propertyBindingTargets, " + this.typeName + ".gen_directiveIndices,\n            " + codegen_facade_1.codify(this.changeDetectionStrategy) + ");\n        this.dehydrateDirectives(false);\n      }\n\n      " + this.typeName + ".prototype = Object.create(" + this.abstractChangeDetectorVarName + ".prototype);\n\n      " + this.typeName + ".prototype.detectChangesInRecordsInternal = function(throwOnChange) {\n        " + this._names.genInitLocals() + "\n        var " + IS_CHANGED_LOCAL + " = false;\n        var " + CHANGES_LOCAL + " = null;\n\n        " + this._genAllRecords(this.records) + "\n      }\n\n      " + this._maybeGenHandleEventInternal() + "\n\n      " + this._maybeGenAfterContentLifecycleCallbacks() + "\n\n      " + this._maybeGenAfterViewLifecycleCallbacks() + "\n\n      " + this._maybeGenHydrateDirectives() + "\n\n      " + this._maybeGenDehydrateDirectives() + "\n\n      " + this._genPropertyBindingTargets() + "\n\n      " + this._genDirectiveIndices() + "\n    ";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genPropertyBindingTargets = function () {
        var targets = this._logic.genPropertyBindingTargets(this.propertyBindingTargets, this.genConfig.genDebugInfo);
        return this.typeName + ".gen_propertyBindingTargets = " + targets + ";";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genDirectiveIndices = function () {
        var indices = this._logic.genDirectiveIndices(this.directiveRecords);
        return this.typeName + ".gen_directiveIndices = " + indices + ";";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenHandleEventInternal = function () {
        var _this = this;
        if (this.eventBindings.length > 0) {
            var handlers = this.eventBindings.map(function (eb) { return _this._genEventBinding(eb); }).join("\n");
            return "\n        " + this.typeName + ".prototype.handleEventInternal = function(eventName, elIndex, locals) {\n          var " + this._names.getPreventDefaultAccesor() + " = false;\n          " + this._names.genInitEventLocals() + "\n          " + handlers + "\n          return " + this._names.getPreventDefaultAccesor() + ";\n        }\n      ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genEventBinding = function (eb) {
        var _this = this;
        var codes = [];
        this._endOfBlockIdxs = [];
        collection_1.ListWrapper.forEachWithIndex(eb.records, function (r, i) {
            var code;
            if (r.isConditionalSkipRecord()) {
                code = _this._genConditionalSkip(r, _this._names.getEventLocalName(eb, i));
            }
            else if (r.isUnconditionalSkipRecord()) {
                code = _this._genUnconditionalSkip(r);
            }
            else {
                code = _this._genEventBindingEval(eb, r);
            }
            code += _this._genEndOfSkipBlock(i);
            codes.push(code);
        });
        return "\n    if (eventName === \"" + eb.eventName + "\" && elIndex === " + eb.elIndex + ") {\n      " + codes.join("\n") + "\n    }";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genEventBindingEval = function (eb, r) {
        if (r.lastInBinding) {
            var evalRecord = this._logic.genEventBindingEvalValue(eb, r);
            var markPath = this._genMarkPathToRootAsCheckOnce(r);
            var prevDefault = this._genUpdatePreventDefault(eb, r);
            return evalRecord + "\n" + markPath + "\n" + prevDefault;
        }
        else {
            return this._logic.genEventBindingEvalValue(eb, r);
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genMarkPathToRootAsCheckOnce = function (r) {
        var br = r.bindingRecord;
        if (br.isDefaultChangeDetection()) {
            return "";
        }
        else {
            return this._names.getDetectorName(br.directiveRecord.directiveIndex) + ".markPathToRootAsCheckOnce();";
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genUpdatePreventDefault = function (eb, r) {
        var local = this._names.getEventLocalName(eb, r.selfIndex);
        return "if (" + local + " === false) { " + this._names.getPreventDefaultAccesor() + " = true};";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenDehydrateDirectives = function () {
        var destroyPipesCode = this._names.genPipeOnDestroy();
        var destroyDirectivesCode = this._logic.genDirectivesOnDestroy(this.directiveRecords);
        var dehydrateFieldsCode = this._names.genDehydrateFields();
        if (!destroyPipesCode && !destroyDirectivesCode && !dehydrateFieldsCode)
            return '';
        return this.typeName + ".prototype.dehydrateDirectives = function(destroyPipes) {\n        if (destroyPipes) {\n          " + destroyPipesCode + "\n          " + destroyDirectivesCode + "\n        }\n        " + dehydrateFieldsCode + "\n    }";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenHydrateDirectives = function () {
        var hydrateDirectivesCode = this._logic.genHydrateDirectives(this.directiveRecords);
        var hydrateDetectorsCode = this._logic.genHydrateDetectors(this.directiveRecords);
        if (!hydrateDirectivesCode && !hydrateDetectorsCode)
            return '';
        return this.typeName + ".prototype.hydrateDirectives = function(directives) {\n      " + hydrateDirectivesCode + "\n      " + hydrateDetectorsCode + "\n    }";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenAfterContentLifecycleCallbacks = function () {
        var notifications = this._logic.genContentLifecycleCallbacks(this.directiveRecords);
        if (notifications.length > 0) {
            var directiveNotifications = notifications.join("\n");
            return "\n        " + this.typeName + ".prototype.afterContentLifecycleCallbacksInternal = function() {\n          " + directiveNotifications + "\n        }\n      ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenAfterViewLifecycleCallbacks = function () {
        var notifications = this._logic.genViewLifecycleCallbacks(this.directiveRecords);
        if (notifications.length > 0) {
            var directiveNotifications = notifications.join("\n");
            return "\n        " + this.typeName + ".prototype.afterViewLifecycleCallbacksInternal = function() {\n          " + directiveNotifications + "\n        }\n      ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genAllRecords = function (rs) {
        var codes = [];
        this._endOfBlockIdxs = [];
        for (var i = 0; i < rs.length; i++) {
            var code = void 0;
            var r = rs[i];
            if (r.isLifeCycleRecord()) {
                code = this._genDirectiveLifecycle(r);
            }
            else if (r.isPipeRecord()) {
                code = this._genPipeCheck(r);
            }
            else if (r.isConditionalSkipRecord()) {
                code = this._genConditionalSkip(r, this._names.getLocalName(r.contextIndex));
            }
            else if (r.isUnconditionalSkipRecord()) {
                code = this._genUnconditionalSkip(r);
            }
            else {
                code = this._genReferenceCheck(r);
            }
            code = "\n        " + this._maybeFirstInBinding(r) + "\n        " + code + "\n        " + this._maybeGenLastInDirective(r) + "\n        " + this._genEndOfSkipBlock(i) + "\n      ";
            codes.push(code);
        }
        return codes.join("\n");
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genConditionalSkip = function (r, condition) {
        var maybeNegate = r.mode === proto_record_1.RecordType.SkipRecordsIf ? '!' : '';
        this._endOfBlockIdxs.push(r.fixedArgs[0] - 1);
        return "if (" + maybeNegate + condition + ") {";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genUnconditionalSkip = function (r) {
        this._endOfBlockIdxs.pop();
        this._endOfBlockIdxs.push(r.fixedArgs[0] - 1);
        return "} else {";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genEndOfSkipBlock = function (protoIndex) {
        if (!collection_1.ListWrapper.isEmpty(this._endOfBlockIdxs)) {
            var endOfBlock = collection_1.ListWrapper.last(this._endOfBlockIdxs);
            if (protoIndex === endOfBlock) {
                this._endOfBlockIdxs.pop();
                return '}';
            }
        }
        return '';
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genDirectiveLifecycle = function (r) {
        if (r.name === "DoCheck") {
            return this._genOnCheck(r);
        }
        else if (r.name === "OnInit") {
            return this._genOnInit(r);
        }
        else if (r.name === "OnChanges") {
            return this._genOnChange(r);
        }
        else {
            throw new exceptions_1.BaseException("Unknown lifecycle event '" + r.name + "'");
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genPipeCheck = function (r) {
        var _this = this;
        var context = this._names.getLocalName(r.contextIndex);
        var argString = r.args.map(function (arg) { return _this._names.getLocalName(arg); }).join(", ");
        var oldValue = this._names.getFieldName(r.selfIndex);
        var newValue = this._names.getLocalName(r.selfIndex);
        var pipe = this._names.getPipeName(r.selfIndex);
        var pipeName = r.name;
        var init = "\n      if (" + pipe + " === " + this.changeDetectionUtilVarName + ".uninitialized) {\n        " + pipe + " = " + this._names.getPipesAccessorName() + ".get('" + pipeName + "');\n      }\n    ";
        var read = newValue + " = " + pipe + ".pipe.transform(" + context + ", [" + argString + "]);";
        var contexOrArgCheck = r.args.map(function (a) { return _this._names.getChangeName(a); });
        contexOrArgCheck.push(this._names.getChangeName(r.contextIndex));
        var condition = "!" + pipe + ".pure || (" + contexOrArgCheck.join(" || ") + ")";
        var check = "\n      " + this._genThrowOnChangeCheck(oldValue, newValue) + "\n      if (" + this.changeDetectionUtilVarName + ".looseNotIdentical(" + oldValue + ", " + newValue + ")) {\n        " + newValue + " = " + this.changeDetectionUtilVarName + ".unwrapValue(" + newValue + ")\n        " + this._genChangeMarker(r) + "\n        " + this._genUpdateDirectiveOrElement(r) + "\n        " + this._genAddToChanges(r) + "\n        " + oldValue + " = " + newValue + ";\n      }\n    ";
        var genCode = r.shouldBeChecked() ? "" + read + check : read;
        if (r.isUsedByOtherRecord()) {
            return init + " if (" + condition + ") { " + genCode + " } else { " + newValue + " = " + oldValue + "; }";
        }
        else {
            return init + " if (" + condition + ") { " + genCode + " }";
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genReferenceCheck = function (r) {
        var _this = this;
        var oldValue = this._names.getFieldName(r.selfIndex);
        var newValue = this._names.getLocalName(r.selfIndex);
        var read = "\n      " + this._logic.genPropertyBindingEvalValue(r) + "\n    ";
        var check = "\n      " + this._genThrowOnChangeCheck(oldValue, newValue) + "\n      if (" + this.changeDetectionUtilVarName + ".looseNotIdentical(" + oldValue + ", " + newValue + ")) {\n        " + this._genChangeMarker(r) + "\n        " + this._genUpdateDirectiveOrElement(r) + "\n        " + this._genAddToChanges(r) + "\n        " + oldValue + " = " + newValue + ";\n      }\n    ";
        var genCode = r.shouldBeChecked() ? "" + read + check : read;
        if (r.isPureFunction()) {
            var condition = r.args.map(function (a) { return _this._names.getChangeName(a); }).join(" || ");
            if (r.isUsedByOtherRecord()) {
                return "if (" + condition + ") { " + genCode + " } else { " + newValue + " = " + oldValue + "; }";
            }
            else {
                return "if (" + condition + ") { " + genCode + " }";
            }
        }
        else {
            return genCode;
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genChangeMarker = function (r) {
        return r.argumentToPureFunction ? this._names.getChangeName(r.selfIndex) + " = true" : "";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genUpdateDirectiveOrElement = function (r) {
        if (!r.lastInBinding)
            return "";
        var newValue = this._names.getLocalName(r.selfIndex);
        var notifyDebug = this.genConfig.logBindingUpdate ? "this.logBindingUpdate(" + newValue + ");" : "";
        var br = r.bindingRecord;
        if (br.target.isDirective()) {
            var directiveProperty = this._names.getDirectiveName(br.directiveRecord.directiveIndex) + "." + br.target.name;
            return "\n        " + directiveProperty + " = " + newValue + ";\n        " + notifyDebug + "\n        " + IS_CHANGED_LOCAL + " = true;\n      ";
        }
        else {
            return "\n        this.notifyDispatcher(" + newValue + ");\n        " + notifyDebug + "\n      ";
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genThrowOnChangeCheck = function (oldValue, newValue) {
        if (lang_1.assertionsEnabled()) {
            return "\n        if (throwOnChange && !" + this.changeDetectionUtilVarName + ".devModeEqual(" + oldValue + ", " + newValue + ")) {\n          this.throwOnChangeError(" + oldValue + ", " + newValue + ");\n        }\n        ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genAddToChanges = function (r) {
        var newValue = this._names.getLocalName(r.selfIndex);
        var oldValue = this._names.getFieldName(r.selfIndex);
        if (!r.bindingRecord.callOnChanges())
            return "";
        return CHANGES_LOCAL + " = this.addChange(" + CHANGES_LOCAL + ", " + oldValue + ", " + newValue + ");";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeFirstInBinding = function (r) {
        var prev = change_detection_util_1.ChangeDetectionUtil.protoByIndex(this.records, r.selfIndex - 1);
        var firstInBinding = lang_1.isBlank(prev) || prev.bindingRecord !== r.bindingRecord;
        return firstInBinding && !r.bindingRecord.isDirectiveLifecycle() ?
            this._names.getPropertyBindingIndex() + " = " + r.propertyBindingIndex + ";" :
            '';
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenLastInDirective = function (r) {
        if (!r.lastInDirective)
            return "";
        return "\n      " + CHANGES_LOCAL + " = null;\n      " + this._genNotifyOnPushDetectors(r) + "\n      " + IS_CHANGED_LOCAL + " = false;\n    ";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genOnCheck = function (r) {
        var br = r.bindingRecord;
        return "if (!throwOnChange) " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngDoCheck();";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genOnInit = function (r) {
        var br = r.bindingRecord;
        return "if (!throwOnChange && " + this._names.getStateName() + " === " + this.changeDetectorStateVarName + ".NeverChecked) " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngOnInit();";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genOnChange = function (r) {
        var br = r.bindingRecord;
        return "if (!throwOnChange && " + CHANGES_LOCAL + ") " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngOnChanges(" + CHANGES_LOCAL + ");";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genNotifyOnPushDetectors = function (r) {
        var br = r.bindingRecord;
        if (!r.lastInDirective || br.isDefaultChangeDetection())
            return "";
        var retVal = "\n      if(" + IS_CHANGED_LOCAL + ") {\n        " + this._names.getDetectorName(br.directiveRecord.directiveIndex) + ".markAsCheckOnce();\n      }\n    ";
        return retVal;
    };
    return ChangeDetectorJITGenerator;
})();
exports.ChangeDetectorJITGenerator = ChangeDetectorJITGenerator;
//# sourceMappingURL=data:application/json;base64,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