var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { IS_DART, isBlank, evalExpression } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { ListWrapper, SetWrapper, StringMapWrapper } from 'angular2/src/facade/collection';
import { PromiseWrapper } from 'angular2/src/facade/async';
import { createHostComponentMeta, CompileDirectiveMetadata } from './directive_metadata';
import { templateVisitAll } from './template_ast';
import { Injectable } from 'angular2/src/core/di';
import { SourceModule, moduleRef, SourceExpression } from './source_module';
import { ChangeDetectionCompiler, CHANGE_DETECTION_JIT_IMPORTS } from './change_detector_compiler';
import { StyleCompiler } from './style_compiler';
import { ViewCompiler, VIEW_JIT_IMPORTS } from './view_compiler';
import { ProtoViewCompiler, APP_VIEW_MODULE_REF, PROTO_VIEW_JIT_IMPORTS } from './proto_view_compiler';
import { TemplateParser, PipeCollector } from './template_parser';
import { TemplateNormalizer } from './template_normalizer';
import { RuntimeMetadataResolver } from './runtime_metadata';
import { HostViewFactory } from 'angular2/src/core/linker/view';
import { ChangeDetectorGenConfig } from 'angular2/src/core/change_detection/change_detection';
import { ResolvedMetadataCache } from 'angular2/src/core/linker/resolved_metadata_cache';
import { codeGenExportVariable, MODULE_SUFFIX, addAll, Expression } from './util';
export var METADATA_CACHE_MODULE_REF = moduleRef('package:angular2/src/core/linker/resolved_metadata_cache' + MODULE_SUFFIX);
/**
 * An internal module of the Angular compiler that begins with component types,
 * extracts templates, and eventually produces a compiled version of the component
 * ready for linking into an application.
 */
export let TemplateCompiler = class {
    constructor(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _cdCompiler, _protoViewCompiler, _viewCompiler, _resolvedMetadataCache, _genConfig) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._cdCompiler = _cdCompiler;
        this._protoViewCompiler = _protoViewCompiler;
        this._viewCompiler = _viewCompiler;
        this._resolvedMetadataCache = _resolvedMetadataCache;
        this._genConfig = _genConfig;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
    }
    normalizeDirectiveMetadata(directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then((normalizedTemplate) => new CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            template: normalizedTemplate
        }));
    }
    compileHostComponentRuntime(type) {
        var compMeta = this._runtimeMetadataResolver.getDirectiveMetadata(type);
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            assertComponent(compMeta);
            var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], [], []);
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then((compiledTemplate) => new HostViewFactory(compMeta.selector, compiledTemplate.viewFactory));
    }
    clearCache() {
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
        this._hostCacheKeys.clear();
    }
    compileTemplatesCodeGen(components) {
        if (components.length === 0) {
            throw new BaseException('No components given');
        }
        var declarations = [];
        components.forEach(componentWithDirs => {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            this._compileComponentCodeGen(compMeta, componentWithDirs.directives, componentWithDirs.pipes, declarations);
            if (compMeta.dynamicLoadable) {
                var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
                var viewFactoryExpression = this._compileComponentCodeGen(hostMeta, [compMeta], [], declarations);
                var constructionKeyword = IS_DART ? 'const' : 'new';
                var compiledTemplateExpr = `${constructionKeyword} ${APP_VIEW_MODULE_REF}HostViewFactory('${compMeta.selector}',${viewFactoryExpression})`;
                var varName = codeGenHostViewFactoryName(compMeta.type);
                declarations.push(`${codeGenExportVariable(varName)}${compiledTemplateExpr};`);
            }
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new SourceModule(`${templateModuleUrl(moduleUrl)}`, declarations.join('\n'));
    }
    compileStylesheetCodeGen(stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    }
    _compileComponentRuntime(cacheKey, compMeta, viewDirectives, pipes, compilingComponentsPath) {
        let uniqViewDirectives = removeDuplicates(viewDirectives);
        let uniqViewPipes = removeDuplicates(pipes);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (isBlank(compiledTemplate)) {
            compiledTemplate = new CompiledTemplate();
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            done = PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(dirMeta => this.normalizeDirectiveMetadata(dirMeta))))
                .then((stylesAndNormalizedViewDirMetas) => {
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var styles = stylesAndNormalizedViewDirMetas[0];
                var parsedTemplate = this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, uniqViewPipes, compMeta.type.name);
                var childPromises = [];
                var usedDirectives = DirectiveCollector.findUsedDirectives(parsedTemplate);
                usedDirectives.components.forEach(component => this._compileNestedComponentRuntime(component, compilingComponentsPath, childPromises));
                return PromiseWrapper.all(childPromises)
                    .then((_) => {
                    var filteredPipes = filterPipes(parsedTemplate, uniqViewPipes);
                    compiledTemplate.init(this._createViewFactoryRuntime(compMeta, parsedTemplate, usedDirectives.directives, styles, filteredPipes));
                    return compiledTemplate;
                });
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    }
    _compileNestedComponentRuntime(childComponentDir, parentCompilingComponentsPath, childPromises) {
        var compilingComponentsPath = ListWrapper.clone(parentCompilingComponentsPath);
        var childCacheKey = childComponentDir.type.runtime;
        var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
        var childViewPipes = this._runtimeMetadataResolver.getViewPipesMetadata(childComponentDir.type.runtime);
        var childIsRecursive = ListWrapper.contains(compilingComponentsPath, childCacheKey);
        compilingComponentsPath.push(childCacheKey);
        this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, childViewPipes, compilingComponentsPath);
        if (!childIsRecursive) {
            // Only wait for a child if it is not a cycle
            childPromises.push(this._compiledTemplateDone.get(childCacheKey));
        }
    }
    _createViewFactoryRuntime(compMeta, parsedTemplate, directives, styles, pipes) {
        if (IS_DART || !this._genConfig.useJit) {
            var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
            var protoViews = this._protoViewCompiler.compileProtoViewRuntime(this._resolvedMetadataCache, compMeta, parsedTemplate, pipes);
            return this._viewCompiler.compileComponentRuntime(compMeta, parsedTemplate, styles, protoViews.protoViews, changeDetectorFactories, (compMeta) => this._getNestedComponentViewFactory(compMeta));
        }
        else {
            var declarations = [];
            var viewFactoryExpr = this._createViewFactoryCodeGen('resolvedMetadataCache', compMeta, new SourceExpression([], 'styles'), parsedTemplate, pipes, declarations);
            var vars = { 'exports': {}, 'styles': styles, 'resolvedMetadataCache': this._resolvedMetadataCache };
            directives.forEach(dirMeta => {
                vars[dirMeta.type.name] = dirMeta.type.runtime;
                if (dirMeta.isComponent && dirMeta.type.runtime !== compMeta.type.runtime) {
                    vars[`viewFactory_${dirMeta.type.name}0`] = this._getNestedComponentViewFactory(dirMeta);
                }
            });
            pipes.forEach(pipeMeta => vars[pipeMeta.type.name] = pipeMeta.type.runtime);
            var declarationsWithoutImports = SourceModule.getSourceWithoutImports(declarations.join('\n'));
            return evalExpression(`viewFactory_${compMeta.type.name}`, viewFactoryExpr, declarationsWithoutImports, mergeStringMaps([vars, CHANGE_DETECTION_JIT_IMPORTS, PROTO_VIEW_JIT_IMPORTS, VIEW_JIT_IMPORTS]));
        }
    }
    _getNestedComponentViewFactory(compMeta) {
        return this._compiledTemplateCache.get(compMeta.type.runtime).viewFactory;
    }
    _compileComponentCodeGen(compMeta, directives, pipes, targetDeclarations) {
        let uniqueDirectives = removeDuplicates(directives);
        let uniqPipes = removeDuplicates(pipes);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, uniqPipes, compMeta.type.name);
        var filteredPipes = filterPipes(parsedTemplate, uniqPipes);
        return this._createViewFactoryCodeGen(`${METADATA_CACHE_MODULE_REF}CODEGEN_RESOLVED_METADATA_CACHE`, compMeta, styleExpr, parsedTemplate, filteredPipes, targetDeclarations);
    }
    _createViewFactoryCodeGen(resolvedMetadataCacheExpr, compMeta, styleExpr, parsedTemplate, pipes, targetDeclarations) {
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var protoViewExprs = this._protoViewCompiler.compileProtoViewCodeGen(new Expression(resolvedMetadataCacheExpr), compMeta, parsedTemplate, pipes);
        var viewFactoryExpr = this._viewCompiler.compileComponentCodeGen(compMeta, parsedTemplate, styleExpr, protoViewExprs.protoViews, changeDetectorsExprs, codeGenComponentViewFactoryName);
        addAll(changeDetectorsExprs.declarations, targetDeclarations);
        addAll(protoViewExprs.declarations, targetDeclarations);
        addAll(viewFactoryExpr.declarations, targetDeclarations);
        return viewFactoryExpr.expression;
    }
};
TemplateCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [RuntimeMetadataResolver, TemplateNormalizer, TemplateParser, StyleCompiler, ChangeDetectionCompiler, ProtoViewCompiler, ViewCompiler, ResolvedMetadataCache, ChangeDetectorGenConfig])
], TemplateCompiler);
export class NormalizedComponentWithViewDirectives {
    constructor(component, directives, pipes) {
        this.component = component;
        this.directives = directives;
        this.pipes = pipes;
    }
}
class CompiledTemplate {
    constructor() {
        this.viewFactory = null;
    }
    init(viewFactory) { this.viewFactory = viewFactory; }
}
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new BaseException(`Could not compile '${meta.type.name}' because it is not a component.`);
    }
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - MODULE_SUFFIX.length);
    return `${urlWithoutSuffix}.template${MODULE_SUFFIX}`;
}
function codeGenHostViewFactoryName(type) {
    return `hostViewFactory_${type.name}`;
}
function codeGenComponentViewFactoryName(nestedCompType) {
    return `${moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl))}viewFactory_${nestedCompType.type.name}0`;
}
function mergeStringMaps(maps) {
    var result = {};
    maps.forEach((map) => { StringMapWrapper.forEach(map, (value, key) => { result[key] = value; }); });
    return result;
}
function removeDuplicates(items) {
    let res = [];
    items.forEach(item => {
        let hasMatch = res.filter(r => r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime)
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
class DirectiveCollector {
    constructor() {
        this.directives = [];
        this.components = [];
    }
    static findUsedDirectives(parsedTemplate) {
        var collector = new DirectiveCollector();
        templateVisitAll(collector, parsedTemplate);
        return collector;
    }
    visitBoundText(ast, context) { return null; }
    visitText(ast, context) { return null; }
    visitNgContent(ast, context) { return null; }
    visitElement(ast, context) {
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) { return null; }
    visitDirective(ast, ctx) {
        if (ast.directive.isComponent) {
            this.components.push(ast.directive);
        }
        this.directives.push(ast.directive);
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        return null;
    }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function filterPipes(template, allPipes) {
    var visitor = new PipeVisitor();
    templateVisitAll(visitor, template);
    return allPipes.filter((pipeMeta) => SetWrapper.has(visitor.collector.pipes, pipeMeta.name));
}
class PipeVisitor {
    constructor() {
        this.collector = new PipeCollector();
    }
    visitBoundText(ast, context) {
        ast.value.visit(this.collector);
        return null;
    }
    visitText(ast, context) { return null; }
    visitNgContent(ast, context) { return null; }
    visitElement(ast, context) {
        templateVisitAll(this, ast.inputs);
        templateVisitAll(this, ast.outputs);
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        templateVisitAll(this, ast.outputs);
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) { return null; }
    visitDirective(ast, ctx) {
        templateVisitAll(this, ast.inputs);
        templateVisitAll(this, ast.hostEvents);
        templateVisitAll(this, ast.hostProperties);
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        ast.handler.visit(this.collector);
        return null;
    }
    visitDirectiveProperty(ast, context) {
        ast.value.visit(this.collector);
        return null;
    }
    visitElementProperty(ast, context) {
        ast.value.visit(this.collector);
        return null;
    }
}
//# sourceMappingURL=data:application/json;base64,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