'use strict';var core_1 = require('angular2/core');
var constants_1 = require('./constants');
var util_1 = require('./util');
var angular = require('./angular_js');
var CAMEL_CASE = /([A-Z])/g;
var INITIAL_VALUE = {
    __UNINITIALIZED__: true
};
var NOT_SUPPORTED = 'NOT_SUPPORTED';
var UpgradeNg1ComponentAdapterBuilder = (function () {
    function UpgradeNg1ComponentAdapterBuilder(name) {
        this.name = name;
        this.inputs = [];
        this.inputsRename = [];
        this.outputs = [];
        this.outputsRename = [];
        this.propertyOutputs = [];
        this.checkProperties = [];
        this.propertyMap = {};
        this.linkFn = null;
        this.directive = null;
        this.$controller = null;
        var selector = name.replace(CAMEL_CASE, function (all, next) { return '-' + next.toLowerCase(); });
        var self = this;
        this.type =
            core_1.Directive({ selector: selector, inputs: this.inputsRename, outputs: this.outputsRename })
                .Class({
                constructor: [
                    new core_1.Inject(constants_1.NG1_SCOPE),
                    core_1.ElementRef,
                    function (scope, elementRef) {
                        return new UpgradeNg1ComponentAdapter(self.linkFn, scope, self.directive, elementRef, self.$controller, self.inputs, self.outputs, self.propertyOutputs, self.checkProperties, self.propertyMap);
                    }
                ],
                ngOnChanges: function () { },
                ngDoCheck: function () { }
            });
    }
    UpgradeNg1ComponentAdapterBuilder.prototype.extractDirective = function (injector) {
        var directives = injector.get(this.name + 'Directive');
        if (directives.length > 1) {
            throw new Error('Only support single directive definition for: ' + this.name);
        }
        var directive = directives[0];
        if (directive.replace)
            this.notSupported('replace');
        if (directive.terminal)
            this.notSupported('terminal');
        var link = directive.link;
        if (typeof link == 'object') {
            if (link.post)
                this.notSupported('link.post');
        }
        return directive;
    };
    UpgradeNg1ComponentAdapterBuilder.prototype.notSupported = function (feature) {
        throw new Error("Upgraded directive '" + this.name + "' does not support '" + feature + "'.");
    };
    UpgradeNg1ComponentAdapterBuilder.prototype.extractBindings = function () {
        var btcIsObject = typeof this.directive.bindToController === 'object';
        if (btcIsObject && Object.keys(this.directive.scope).length) {
            throw new Error("Binding definitions on scope and controller at the same time are not supported.");
        }
        var context = (btcIsObject) ? this.directive.bindToController : this.directive.scope;
        if (typeof context == 'object') {
            for (var name in context) {
                if (context.hasOwnProperty(name)) {
                    var localName = context[name];
                    var type = localName.charAt(0);
                    localName = localName.substr(1) || name;
                    var outputName = 'output_' + name;
                    var outputNameRename = outputName + ': ' + name;
                    var outputNameRenameChange = outputName + ': ' + name + 'Change';
                    var inputName = 'input_' + name;
                    var inputNameRename = inputName + ': ' + name;
                    switch (type) {
                        case '=':
                            this.propertyOutputs.push(outputName);
                            this.checkProperties.push(localName);
                            this.outputs.push(outputName);
                            this.outputsRename.push(outputNameRenameChange);
                            this.propertyMap[outputName] = localName;
                        // don't break; let it fall through to '@'
                        case '@':
                            this.inputs.push(inputName);
                            this.inputsRename.push(inputNameRename);
                            this.propertyMap[inputName] = localName;
                            break;
                        case '&':
                            this.outputs.push(outputName);
                            this.outputsRename.push(outputNameRename);
                            this.propertyMap[outputName] = localName;
                            break;
                        default:
                            var json = JSON.stringify(context);
                            throw new Error("Unexpected mapping '" + type + "' in '" + json + "' in '" + this.name + "' directive.");
                    }
                }
            }
        }
    };
    UpgradeNg1ComponentAdapterBuilder.prototype.compileTemplate = function (compile, templateCache, httpBackend) {
        var _this = this;
        if (this.directive.template !== undefined) {
            this.linkFn = compileHtml(this.directive.template);
        }
        else if (this.directive.templateUrl) {
            var url = this.directive.templateUrl;
            var html = templateCache.get(url);
            if (html !== undefined) {
                this.linkFn = compileHtml(html);
            }
            else {
                return new Promise(function (resolve, err) {
                    httpBackend('GET', url, null, function (status, response) {
                        if (status == 200) {
                            resolve(_this.linkFn = compileHtml(templateCache.put(url, response)));
                        }
                        else {
                            err("GET " + url + " returned " + status + ": " + response);
                        }
                    });
                });
            }
        }
        else {
            throw new Error("Directive '" + this.name + "' is not a component, it is missing template.");
        }
        return null;
        function compileHtml(html) {
            var div = document.createElement('div');
            div.innerHTML = html;
            return compile(div.childNodes);
        }
    };
    UpgradeNg1ComponentAdapterBuilder.resolve = function (exportedComponents, injector) {
        var promises = [];
        var compile = injector.get(constants_1.NG1_COMPILE);
        var templateCache = injector.get(constants_1.NG1_TEMPLATE_CACHE);
        var httpBackend = injector.get(constants_1.NG1_HTTP_BACKEND);
        var $controller = injector.get(constants_1.NG1_CONTROLLER);
        for (var name in exportedComponents) {
            if (exportedComponents.hasOwnProperty(name)) {
                var exportedComponent = exportedComponents[name];
                exportedComponent.directive = exportedComponent.extractDirective(injector);
                exportedComponent.$controller = $controller;
                exportedComponent.extractBindings();
                var promise = exportedComponent.compileTemplate(compile, templateCache, httpBackend);
                if (promise)
                    promises.push(promise);
            }
        }
        return Promise.all(promises);
    };
    return UpgradeNg1ComponentAdapterBuilder;
})();
exports.UpgradeNg1ComponentAdapterBuilder = UpgradeNg1ComponentAdapterBuilder;
var UpgradeNg1ComponentAdapter = (function () {
    function UpgradeNg1ComponentAdapter(linkFn, scope, directive, elementRef, $controller, inputs, outputs, propOuts, checkProperties, propertyMap) {
        this.directive = directive;
        this.inputs = inputs;
        this.outputs = outputs;
        this.propOuts = propOuts;
        this.checkProperties = checkProperties;
        this.propertyMap = propertyMap;
        this.destinationObj = null;
        this.checkLastValues = [];
        var element = elementRef.nativeElement;
        var childNodes = [];
        var childNode;
        while (childNode = element.firstChild) {
            element.removeChild(childNode);
            childNodes.push(childNode);
        }
        var componentScope = scope.$new(!!directive.scope);
        var $element = angular.element(element);
        var controllerType = directive.controller;
        var controller = null;
        if (controllerType) {
            var locals = { $scope: componentScope, $element: $element };
            controller = $controller(controllerType, locals, null, directive.controllerAs);
            $element.data(util_1.controllerKey(directive.name), controller);
        }
        var link = directive.link;
        if (typeof link == 'object')
            link = link.pre;
        if (link) {
            var attrs = NOT_SUPPORTED;
            var transcludeFn = NOT_SUPPORTED;
            var linkController = this.resolveRequired($element, directive.require);
            directive.link(componentScope, $element, attrs, linkController, transcludeFn);
        }
        this.destinationObj = directive.bindToController && controller ? controller : componentScope;
        linkFn(componentScope, function (clonedElement, scope) {
            for (var i = 0, ii = clonedElement.length; i < ii; i++) {
                element.appendChild(clonedElement[i]);
            }
        }, { parentBoundTranscludeFn: function (scope, cloneAttach) { cloneAttach(childNodes); } });
        for (var i = 0; i < inputs.length; i++) {
            this[inputs[i]] = null;
        }
        for (var j = 0; j < outputs.length; j++) {
            var emitter = this[outputs[j]] = new core_1.EventEmitter();
            this.setComponentProperty(outputs[j], (function (emitter) { return function (value) { return emitter.emit(value); }; })(emitter));
        }
        for (var k = 0; k < propOuts.length; k++) {
            this[propOuts[k]] = new core_1.EventEmitter();
            this.checkLastValues.push(INITIAL_VALUE);
        }
    }
    UpgradeNg1ComponentAdapter.prototype.ngOnChanges = function (changes) {
        for (var name in changes) {
            if (changes.hasOwnProperty(name)) {
                var change = changes[name];
                this.setComponentProperty(name, change.currentValue);
            }
        }
    };
    UpgradeNg1ComponentAdapter.prototype.ngDoCheck = function () {
        var count = 0;
        var destinationObj = this.destinationObj;
        var lastValues = this.checkLastValues;
        var checkProperties = this.checkProperties;
        for (var i = 0; i < checkProperties.length; i++) {
            var value = destinationObj[checkProperties[i]];
            var last = lastValues[i];
            if (value !== last) {
                if (typeof value == 'number' && isNaN(value) && typeof last == 'number' && isNaN(last)) {
                }
                else {
                    var eventEmitter = this[this.propOuts[i]];
                    eventEmitter.emit(lastValues[i] = value);
                }
            }
        }
        return count;
    };
    UpgradeNg1ComponentAdapter.prototype.setComponentProperty = function (name, value) {
        this.destinationObj[this.propertyMap[name]] = value;
    };
    UpgradeNg1ComponentAdapter.prototype.resolveRequired = function ($element, require) {
        if (!require) {
            return undefined;
        }
        else if (typeof require == 'string') {
            var name = require;
            var isOptional = false;
            var startParent = false;
            var searchParents = false;
            var ch;
            if (name.charAt(0) == '?') {
                isOptional = true;
                name = name.substr(1);
            }
            if (name.charAt(0) == '^') {
                searchParents = true;
                name = name.substr(1);
            }
            if (name.charAt(0) == '^') {
                startParent = true;
                name = name.substr(1);
            }
            var key = util_1.controllerKey(name);
            if (startParent)
                $element = $element.parent();
            var dep = searchParents ? $element.inheritedData(key) : $element.data(key);
            if (!dep && !isOptional) {
                throw new Error("Can not locate '" + require + "' in '" + this.directive.name + "'.");
            }
            return dep;
        }
        else if (require instanceof Array) {
            var deps = [];
            for (var i = 0; i < require.length; i++) {
                deps.push(this.resolveRequired($element, require[i]));
            }
            return deps;
        }
        throw new Error("Directive '" + this.directive.name + "' require syntax unrecognized: " + this.directive.require);
    };
    return UpgradeNg1ComponentAdapter;
})();
//# sourceMappingURL=data:application/json;base64,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