/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.as.cli.gui.OperationDialog;
import org.jboss.as.cli.gui.component.ServerLogsTable;
import org.jboss.as.cli.gui.component.ServerLogsTableModel;
import org.jboss.as.cli.gui.metacommand.DownloadServerLogDialog;
import org.jboss.dmr.ModelNode;

public class ServerLogsPanel
extends JPanel {
    private ServerLogsTable table;
    private ServerLogsTableModel tableModel;
    private CliGuiContext cliGuiCtx;
    private ManagementModelNode loggingSubsys;

    public ServerLogsPanel(CliGuiContext cliGuiCtx, ManagementModelNode loggingSubsys) {
        this.cliGuiCtx = cliGuiCtx;
        this.loggingSubsys = loggingSubsys;
        this.setLayout(new BorderLayout());
        this.table = new ServerLogsTable();
        this.tableModel = new ServerLogsTableModel(cliGuiCtx, this.table);
        this.table.setModel(this.tableModel);
        this.tableModel.refresh();
        JScrollPane scroller = new JScrollPane(this.table);
        this.add((Component)scroller, "Center");
        this.add((Component)this.makeButtonPanel(), "South");
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(new ViewWithCLIButton());
        buttonPanel.add(new DownloadButton());
        buttonPanel.add(new RefreshButton());
        return buttonPanel;
    }

    private String getSelectedFileName() {
        return (String)this.table.getValueAt(this.table.getSelectedRow(), 0);
    }

    private Long getSelectedFileSize() {
        return (Long)this.table.getValueAt(this.table.getSelectedRow(), 2);
    }

    private class RefreshButton
    extends JButton {
        public RefreshButton() {
            super("Refresh List");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerLogsPanel.this.tableModel.refresh();
                }
            });
        }
    }

    private class DownloadButton
    extends JButton {
        public DownloadButton() {
            super("Download");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DownloadServerLogDialog dialog = new DownloadServerLogDialog(ServerLogsPanel.this.cliGuiCtx, ServerLogsPanel.this.getSelectedFileName(), ServerLogsPanel.this.getSelectedFileSize());
                    dialog.setLocationRelativeTo(ServerLogsPanel.this.cliGuiCtx.getMainWindow());
                    dialog.setVisible(true);
                }
            });
        }
    }

    private class ViewWithCLIButton
    extends JButton {
        private String description;
        private ModelNode requestProperties;

        public ViewWithCLIButton() {
            super("View with CLI");
            this.retrieveOpDescription();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OperationDialog opDialog = new OperationDialog(ServerLogsPanel.this.cliGuiCtx, ServerLogsPanel.this.loggingSubsys, "read-log-file", ViewWithCLIButton.this.description, ViewWithCLIButton.this.requestProperties);
                    opDialog.setValue("name", ServerLogsPanel.this.getSelectedFileName());
                    opDialog.setLocationRelativeTo(ServerLogsPanel.this.cliGuiCtx.getMainWindow());
                    opDialog.setVisible(true);
                }
            });
        }

        private void retrieveOpDescription() {
            try {
                ModelNode result = ServerLogsPanel.this.cliGuiCtx.getExecutor().doCommand("/subsystem=logging/:read-operation-description(name=read-log-file)");
                this.description = result.get(new String[]{"result", "description"}).asString();
                this.requestProperties = result.get(new String[]{"result", "request-properties"});
            }
            catch (IOException | CommandFormatException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

