package org.keycloak.events;

/**
 * @author <a href="mailto:sthorger@redhat.com">Stian Thorgersen</a>
 */
public enum EventType {

    LOGIN,
    LOGIN_ERROR,
    REGISTER,
    REGISTER_ERROR,
    LOGOUT,
    LOGOUT_ERROR,
    CODE_TO_TOKEN,
    CODE_TO_TOKEN_ERROR,
    REFRESH_TOKEN,
    VALIDATE_ACCESS_TOKEN,
    VALIDATE_ACCESS_TOKEN_ERROR,
    REFRESH_TOKEN_ERROR,
    SOCIAL_LINK,
    SOCIAL_LINK_ERROR,
    REMOVE_FEDERATED_IDENTITY,
    REMOVE_SOCIAL_LINK_ERROR,

    UPDATE_EMAIL,
    UPDATE_EMAIL_ERROR,
    UPDATE_PROFILE,
    UPDATE_PROFILE_ERROR,
    UPDATE_PASSWORD,
    UPDATE_PASSWORD_ERROR,
    UPDATE_TOTP,
    UPDATE_TOTP_ERROR,
    VERIFY_EMAIL,
    VERIFY_EMAIL_ERROR,

    REMOVE_TOTP,
    REMOVE_TOTP_ERROR,

    SEND_VERIFY_EMAIL,
    SEND_VERIFY_EMAIL_ERROR,
    SEND_RESET_PASSWORD,
    SEND_RESET_PASSWORD_ERROR,
    RESET_PASSWORD,
    RESET_PASSWORD_ERROR,

    INVALID_SIGNATURE_ERROR,
    REGISTER_NODE,
    UNREGISTER_NODE,

    USER_INFO_REQUEST,
    USER_INFO_REQUEST_ERROR,

    IDENTITY_PROVIDER_LOGIN,
    IDENTITY_PROVIDER_LOGIN_ERROR,
    IDENTITY_PROVIDER_RESPONSE,
    IDENTITY_PROVIDER_RESPONSE_ERROR,
    IDENTITY_PROVIDER_RETRIEVE_TOKEN,
    IDENTITY_PROVIDER_RETRIEVE_TOKEN_ERROR,
    IDENTITY_PROVIDER_ACCCOUNT_LINKING,
    IDENTITY_PROVIDER_ACCCOUNT_LINKING_ERROR,
    
    VIEW_REALM,
    UPDATE_REALM,
    DELETE_REALM,
    IMPORT_REALM,
    UPLOAD_REALM,
    VIEW_REALM_APPLICATIONS,
    SET_REALM_USER_PERMISSIONS,
    SET_REALM_ADAPTER_CONFIGURATION,
    
    CREATE_APPLICATION,
    UPDATE_APPLICATION,
    VIEW_APPLICATION,
    DELETE_APPLICATION,
    
    VIEW_APPLICATION_USER_SESSIONS,
    INVALIDATE_APPLICATION_USER_SESSIONS,
    INVALIDATE_APPLICATION_USER_SESSION,
    REGISTER_APPLICATION_CLUSTER_NODE,
    UNREGISTER_APPLICATION_CLUSTER_NODE,
    
    VIEW_CLIENT_CERTIFICATE,
    GENERATE_CLIENT_CERTIFICATE,
    UPLOAD_CLIENT_CERTIFICATE,
    DOWNLOAD_CLIENT_CERTIFICATE,
    
    VIEW_IDENTITY_PROVIDER,
    VIEW_IDENTITY_PROVIDERS,
    IMPORT_IDENTITY_PROVIDER_CONFIG,
    CREATE_IDENTITY_PROVIDER,
    UPDATE_IDENTITY_PROVIDER,
    DELETE_IDENTITY_PROVIDER,
    
    CREATE_OAUTH_CLIENT,
    UPDATE_OAUTH_CLIENT,
    VIEW_OAUTH_CLIENT,
    VIEW_OAUTH_CLIENTS,
    DELETE_OAUTH_CLIENT,
    
    VIEW_ROLE,
    VIEW_ROLES,
    CREATE_ROLE,
    UPDATE_ROLE,
    DELETE_ROLE,
    MAKE_ROLE_COMPOSITE,
    
    UPDATE_USER,
    CREATE_USER,
    VIEW_USER,
    DELETE_USER,
    VIEW_USER_SESSIONS,
    VIEW_USER_SOCIAL_LOGINS,
    INVALIDATE_USER_SESSIONS,
    
    CREATE_PROVIDER,
    VIEW_PROVIDER,
    VIEW_PROVIDER_FACTORIES,
    UPDATE_PROVIDER,
    DELETE_PROVIDER,
    
    VIEW_SERVER_INFO,
    
}
