/**!
 * FileAPI  a set of tools for working with files
 *
 * @author  RubaXa  <trash@rubaxa.org>
 * @build	lib/canvas-to-blob lib/FileAPI.core lib/FileAPI.Image lib/FileAPI.Form lib/FileAPI.XHR lib/FileAPI.Flash
 */
(function(a){var k=a.HTMLCanvasElement&&a.HTMLCanvasElement.prototype,g;if(g=a.Blob)try{g=Boolean(new Blob)}catch(j){g=!1}var m=g;if(g=m)if(g=a.Uint8Array)try{g=100===(new Blob([new Uint8Array(100)])).size}catch(f){g=!1}var c=g,e=a.BlobBuilder||a.WebKitBlobBuilder||a.MozBlobBuilder||a.MSBlobBuilder,q=(m||e)&&a.atob&&a.ArrayBuffer&&a.Uint8Array&&function(a){var l,f,u,g;l=0<=a.split(",")[0].indexOf("base64")?atob(a.split(",")[1]):decodeURIComponent(a.split(",")[1]);f=new ArrayBuffer(l.length);u=new Uint8Array(f);
for(g=0;g<l.length;g+=1)u[g]=l.charCodeAt(g);a=a.split(",")[0].split(":")[1].split(";")[0];if(m)return new Blob([c?u:f],{type:a});u=new e;u.append(f);return u.getBlob(a)};a.HTMLCanvasElement&&!k.toBlob&&(k.mozGetAsFile?k.toBlob=function(a,c){a(this.mozGetAsFile("blob",c))}:k.toDataURL&&q&&(k.toBlob=function(a,c){a(q(this.toDataURL(c)))}));"function"===typeof define&&define.amd?define(function(){return q}):a.dataURLtoBlob=q})(this);
(function(a,k){function g(b,E,a){if(b)if(l(b))for(var d=0,c=b.length;d<c;d++)d in b&&E.call(a,b[d],d,b);else for(d in b)b.hasOwnProperty(d)&&E.call(a,b[d],d,b)}function j(b,d,a){if(b){var c=h.uid(b);D[c]||(D[c]={});g(d.split(/\s+/),function(d){n?n.event.add(b,d,a):(D[c][d]||(D[c][d]=[]),D[c][d].push(a),b.addEventListener?b.addEventListener(d,a,!1):b.attachEvent?b.attachEvent("on"+d,a):b["on"+d]=a)})}}function m(b,d,a){if(b){var c=h.uid(b),e=D[c]||{};g(d.split(/\s+/),function(d){if(n)n.event.remove(b,
d,a);else{for(var E=e[d]||[],c=E.length;c--;)if(E[c]===a){E.splice(c,1);break}b.addEventListener?b.removeEventListener(d,a,!1):b.detachEvent?b.detachEvent("on"+d,a):b["on"+d]=null}})}}function f(b,d,a){j(b,d,function P(c){m(b,d,P);a(c)})}function c(b,d,a,c,e){b={type:a.type||a,target:b,result:c};h.extend(b,e);d(b)}function e(b,d,a,e){if(h.isFile(b)&&p&&p.prototype["readAs"+a]){var n=new p;j(n,K,function Q(a){var e=a.type;"progress"==e?c(b,d,a,a.target.result,{loaded:a.loaded,total:a.total}):"loadend"==
e?(m(n,K,Q),n=null):c(b,d,a,a.target.result)});try{if(e)n["readAs"+a](e,b);else n["readAs"+a](b)}catch(l){c(b,d,"error",k,{error:l.toString()})}}else c(b,d,"error",k,{error:"filreader_not_support_"+a})}function q(b){var d;b.getAsEntry?d=b.getAsEntry():b.webkitGetAsEntry&&(d=b.webkitGetAsEntry());return d}function t(b,d){if(b)if(b.isFile)b.file(function(b){d(!1,[b])},function(){d("entry_file")});else if(b.isDirectory){var a=[];b.createReader().readEntries(function(b){h.afor(b,function(b,c){t(c,function(c,
e){c||(a=a.concat(e));b?b():d(!1,a)})})},function(){d("directory_reader")})}else t(q(b),d);else d("empty_entry")}function l(b){return"object"==typeof b&&b&&"length"in b}function A(b){b.target||(b.target=a.event&&a.event.srcElement||M);3===b.target.nodeType&&(b.target=event.target.parentNode);return b}var u=1,C=function(){},s=navigator.userAgent,y=a.createObjectURL&&a||a.URL&&URL.revokeObjectURL&&URL||a.webkitURL&&webkitURL,r=a.Blob,v=a.File,p=a.FileReader,w=a.FormData,d=a.XMLHttpRequest,n=a.jQuery,
x=!(!v||!p||!a.Uint8Array&&!w&&!d.prototype.sendAsBinary)&&!(/safari\//i.test(s)&&!/chrome\//i.test(s)&&/windows/i.test(s)),s=x&&"withCredentials"in new d,r=x&&!!r&&!(!r.prototype.webkitSlice&&!r.prototype.mozSlice&&!r.prototype.slice),M=a.document,F=a.dataURLtoBlob,T=/img/i,U=/canvas/i,V=/img|canvas/,L=/input/i,I=/^data:[^,]+,/,G=Math.pow,W=Math.round,z=Number,w=function(b){return W(b*this)},H=new z(1024),N=new z(G(H,2)),J=new z(G(H,3)),G=new z(G(H,4)),D={},O=[],K="abort progress error load loadend",
X="status statusText readyState response responseXML responseText responseBody".split(" "),h={version:"1.2.5",cors:!1,html5:!0,debug:!1,pingUrl:!1,withCredentials:!0,staticPath:"./",flashUrl:0,flashImageUrl:0,accept:{"image/*":"art bm bmp dwg dxf cbr cbz fif fpx gif ico iefs jfif jpe jpeg jpg jps jut mcf nap nif pbm pcx pgm pict pm png pnm qif qtif ras rast rf rp svf tga tif tiff xbm xbm xpm xwd","audio/*":"m4a flac aac rm mpa wav wma ogg mp3 mp2 m3u mod amf dmf dsm far gdm imf it m15 med okt s3m stm sfx ult uni xm sid ac3 dts cue aif aiff wpl ape mac mpc mpp shn wv nsf spc gym adplug adx dsp adp ymf ast afc hps xs",
"video/*":"m4v 3gp nsv ts ty strm rm rmvb m3u ifo mov qt divx xvid bivx vob nrg img iso pva wmv asf asx ogm m2v avi bin dat dvr-ms mpg mpeg mp4 mkv avc vp3 svq3 nuv viv dv fli flv wpl"},chunkSize:0,chunkUploadRetry:0,chunkNetworkDownRetryTimeout:2E3,KB:(H.from=w,H),MB:(N.from=w,N),GB:(J.from=w,J),TB:(G.from=w,G),expando:"fileapi"+(new Date).getTime(),uid:function(b){return b?b[h.expando]=b[h.expando]||h.uid():(++u,h.expando+u)},log:function(){h.debug&&(a.console&&console.log)&&(console.log.apply?
console.log.apply(console,arguments):console.log([].join.call(arguments," ")))},getXHR:function(){var b;if(d)b=new d;else if(a.ActiveXObject)try{b=new ActiveXObject("MSXML2.XMLHttp.3.0")}catch(c){b=new ActiveXObject("Microsoft.XMLHTTP")}return b},isArray:l,support:{dnd:s&&"ondrop"in M.createElement("div"),cors:s,html5:x,chunked:r,dataURI:!0},event:{on:j,off:m,one:f,fix:A},throttle:function(b,d){var c,e;return function(){e=arguments;c||(b.apply(a,e),c=setTimeout(function(){c=0;b.apply(a,e)},d))}},
F:function(){},parseJSON:function(b){return a.JSON&&JSON.parse?JSON.parse(b):(new Function("return ("+b.replace(/([\r\n])/g,"\\$1")+");"))()},trim:function(b){b=String(b);return b.trim?b.trim():b.replace(/^\s+|\s+$/g,"")},defer:function(){var b=[],d,a,c={resolve:function(e,n){c.resolve=C;a=e||!1;for(d=n;n=b.shift();)n(a,d)},then:function(c){a!==k?c(a,d):b.push(c)}};return c},queue:function(b){var d=0,a=0,c=!1,e=!1,n={inc:function(){a++},next:function(){d++;setTimeout(n.check,0)},check:function(){d>=
a&&!c&&n.end()},isFail:function(){return c},fail:function(){!c&&b(c=!0)},end:function(){e||(e=!0,b())}};return n},each:g,afor:function(b,d){var a=0,c=b.length;l(b)&&c--?function B(){d(c!=a&&B,b[a],a++)}():d(!1)},extend:function(b){g(arguments,function(d){g(d,function(d,a){b[a]=d})});return b},isFile:function(b){return x&&b&&b instanceof v},isCanvas:function(b){return b&&U.test(b.nodeName)},getFilesFilter:function(b){return(b="string"==typeof b?b:b.getAttribute&&b.getAttribute("accept")||"")?RegExp("("+
b.replace(/\./g,"\\.").replace(/,/g,"|")+")$","i"):/./},readAsDataURL:function(b,d){h.isCanvas(b)?c(b,d,"load",h.toDataURL(b)):e(b,d,"DataURL")},readAsBinaryString:function(b,d){p&&p.prototype.readAsBinaryString?e(b,d,"BinaryString"):e(b,function(b){if("load"==b.type)try{b.result=h.toBinaryString(b.result)}catch(a){b.type="error",b.message=a.toString()}d(b)},"DataURL")},readAsArrayBuffer:function(b,d){e(b,d,"ArrayBuffer")},readAsText:function(b,d,a){a||(a=d,d="utf-8");e(b,a,"Text",d)},toDataURL:function(b){if("string"==
typeof b)return b;if(b.toDataURL)return b.toDataURL("image/png")},toBinaryString:function(b){return a.atob(h.toDataURL(b).replace(I,""))},readAsImage:function(b,d,a){if(h.isFile(b))if(y){var e=y.createObjectURL(b);e===k?c(b,d,"error"):h.readAsImage(e,d,a)}else h.readAsDataURL(b,function(e){"load"==e.type?h.readAsImage(e.result,d,a):(a||"error"==e.type)&&c(b,d,e,null,{loaded:e.loaded,total:e.total})});else h.isCanvas(b)?c(b,d,"load",b):T.test(b.nodeName)?b.complete?c(b,d,"load",b):f(b,"error abort load",
function B(a){"load"==a.type&&y&&y.revokeObjectURL(b.src);m(b,"error abort load",B);c(b,d,a,b)}):b.iframe?c(b,d,{type:"error"}):(e=new Image,e.src=b.dataURL||b,h.readAsImage(e,d,a))},checkFileObj:function(b){var d={},a=h.accept;"object"==typeof b?d=b:d.name=(b+"").split(/\\|\//g).pop();null==d.type&&(d.type=d.name.split(".").pop());g(a,function(b,a){b=RegExp(b.replace(/\s/g,"|"),"i");b.test(d.type)&&(d.type=a.split("/")[0]+"/"+d.type)});return d},getDropFiles:function(b,d){var a=[],c=(b.originalEvent||
b||"").dataTransfer||{},e=l(c.items)&&c.items[0]&&q(c.items[0]),n=h.queue(function(){d(a)});g((e?c.items:c.files)||[],function(b){n.inc();if(e)t(b,function(b,d){!b&&a.push.apply(a,d);n.next()});else{var d=function(d){d&&a.push(b);n.next()};if(!b.type&&0==b.size%4096&&102400>=b.size)if(p)try{var c=new p;f(c,K,function(b){b="error"!=b.type;d(b);b&&c.abort()});c.readAsDataURL(b)}catch(l){d(!1)}else d(null);else d(!0)}});n.check()},getFiles:function(b,d,a){var c=[];if(a)return h.filterFiles(h.getFiles(b),
d,a),null;b.jquery&&(b.each(function(){c=c.concat(h.getFiles(this))}),b=c,c=[]);"string"==typeof d&&(d=h.getFilesFilter(d));b.originalEvent?b=A(b.originalEvent):b.srcElement&&(b=A(b));b.dataTransfer?b=b.dataTransfer:b.target&&(b=b.target);b.files?c=b.files:!x&&L.test(b&&b.tagName)?h.trim(b.value)&&(c=[h.checkFileObj(b.value)],c[0].blob=b,c[0].iframe=!0):l(b)&&(c=b);return h.filter(c,function(b){return!d||d.test(b.name)})},getInfo:function(b,d){var a={},c=O.concat();h.isFile(b)?function B(){var e=
c.shift();e?e.test(b.type)?e(b,function(b,c){b?d(b):(h.extend(a,c),B())}):B():d(!1,a)}():d("not_support",a)},addInfoReader:function(b,d){d.test=function(d){return b.test(d)};O.push(d)},filter:function(b,d){for(var a=[],c=0,e=b.length,n;c<e;c++)c in b&&(n=b[c],d.call(n,n,c,b)&&a.push(n));return a},filterFiles:function(b,d,a){if(b.length){var c=b.concat(),e,n=[],l=[];(function R(){c.length?(e=c.shift(),h.getInfo(e,function(b,a){(d(e,b?!1:a)?n:l).push(e);R()})):a(n,l)})()}else a([],b)},upload:function(b){b=
h.extend({prepare:h.F,beforeupload:h.F,upload:h.F,fileupload:h.F,fileprogress:h.F,filecomplete:h.F,progress:h.F,complete:h.F,pause:h.F,chunkSize:h.chunkSize,chunkUpoloadRetry:h.chunkUploadRetry},b);b.imageAutoOrientation&&!b.imageTransform&&(b.imageTransform={rotate:"auto"});var d=new h.XHR(b),a=this._getFilesDataArray(b.files),c=0,e=0,n=this,l,f=!1;g(a,function(b){c+=b.size});d.files=[];g(a,function(b){d.files.push(b.file)});d.total=c;d.loaded=0;b.beforeupload(d,b);(l=function S(){var l=a.shift(),
t=l&&l.file,x=!1,u={};g(b,function(b,d){b&&"object"===typeof b&&(b=h.extend({},b));u[d]=b});t&&t.name===h.expando&&(t=null,h.log("[warn] FileAPI.upload() \u2014 called without files"));("abort"!=d.statusText||d.current)&&l?(f=!1,(d.currentFile=t)&&b.prepare(t,u),this._getFormData(u,l,function(a){e||b.upload(d,b);var f=new h.XHR(h.extend({},u,{upload:t?function(){b.fileupload(t,f,u)}:C,progress:t?function(a){x||(b.fileprogress({type:"progress",total:l.total=a.total,loaded:l.loaded=a.loaded},t,f,u),
b.progress({type:"progress",total:c,loaded:d.loaded=e+l.size*(a.loaded/a.total)|0},t,f,u))}:C,complete:function(a){x=!0;g(X,function(b){d[b]=f[b]});t&&(l.loaded=l.total,this.progress(l),e+=l.size,d.loaded=e,b.filecomplete(a,f,t,u));S.call(n)}}));d.abort=function(b){this.current=b;f.abort()};f.send(a)})):(b.complete(200==d.status||201==d.status?!1:d.statusText||"error",d,b),f=!0)}).call(this);d.append=function(b,e){b=h._getFilesDataArray([].concat(b));g(b,function(b){c+=b.size;d.files.push(b.file);
e?a.unshift(b):a.push(b)});f&&l.call(n)};d.remove=function(b){var d=-1;g(a,function(c){d++;if(c.file==b)return a.splice(d,1)})};return d},_getFilesDataArray:function(b){var d=[],a={};if(L.test(b&&b.tagName)){var c=h.getFiles(b);a[b.name||"file"]=null!==b.getAttribute("multiple")?c:c[0]}else l(b)&&L.test(b[0]&&b[0].tagName)?g(b,function(b){a[b.name||"file"]=h.getFiles(b)}):a=b;g(a,function B(b,a){l(b)?g(b,function(b){B(b,a)}):b&&b.name&&d.push({name:a,file:b,size:b.size,total:b.size,loaded:0})});d.length||
d.push({file:{name:h.expando}});return d},_getFormData:function(b,d,a){var c=d.file,e=d.name,n=c.name,l=c.type;d=h.support.transform&&b.imageTransform;var f=new h.Form,t=h.queue(function(){a(f)}),x=d&&(0<parseInt(d.maxWidth||d.minWidth||d.width,10)||d.rotate);h.Image&&d&&(/image/.test(c.type)||V.test(c.nodeType))?(t.inc(),x&&(d=[d]),h.Image.transform(c,d,b.imageAutoOrientation,function(d,a){x&&!d?(!F&&!h.flashEngine&&(a[0]=h.toBinaryString(a[0]),f.multipart=!0),f.append(e,a[0],n,l)):(d||(g(a,function(b,
d){!F&&!h.flashEngine&&(b=h.toBinaryString(b),f.multipart=!0);f.append(e+"["+d+"]",b,n,l)}),e+="[original]"),(d||b.imageOriginal)&&f.append(e,c,n,l));t.next()})):n!==h.expando&&f.append(e,c,n);g(b.data,function Y(b,d){"object"==typeof b?g(b,function(b,a){Y(b,d+"["+a+"]")}):f.append(d,b)});t.check()},reset:function(b){var d,a;n?(a=n(b).clone(!0).insertBefore(b).val("")[0],n(b).remove()):(d=b.parentNode,a=d.insertBefore(b.cloneNode(!0),b),a.value="",d.removeChild(b),g(D[h.uid(b)],function(d,c){g(d,
function(d){m(b,c,d);j(a,c,d)})}));return a},load:function(b,d){var a=h.getXHR();a?(a.open("GET",b,!0),a.overrideMimeType&&a.overrideMimeType("text/plain; charset=x-user-defined"),j(a,"progress",function(b){b.lengthComputable&&d({type:b.type,loaded:b.loaded,total:b.total},a)}),a.onreadystatechange=function(){if(4==a.readyState)if(a.onreadystatechange=null,200==a.status){b=b.split("/");var c={name:b[b.length-1],size:a.getResponseHeader("Content-Length"),type:a.getResponseHeader("Content-Type")};c.dataURL=
"data:"+c.type+";base64,"+h.encode64(a.responseBody||a.responseText);d({type:"load",result:c})}else d({type:"error"})},a.send(null)):d({type:"error"});return a},encode64:function(b){var d="",a=0;for("string"!==typeof b&&(b=String(b));a<b.length;){var c=b.charCodeAt(a++)&255,e=b.charCodeAt(a++)&255,n=b.charCodeAt(a++)&255,l=c>>2,c=(c&3)<<4|e>>4;isNaN(e)?e=n=64:(e=(e&15)<<2|n>>6,n=isNaN(n)?64:n&63);d+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(l)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(c)+
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(e)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(n)}return d}};h.addInfoReader(/^image/,function(b,d){if(!b.__dimensions){var a=b.__dimensions=h.defer();h.readAsImage(b,function(b){var d=b.target;a.resolve("load"==b.type?!1:"error",{width:d.width,height:d.height})})}b.__dimensions.then(d)});h.event.dnd=function(b,d,a){var c,e;a||(a=d,d=h.F);p?(j(b,"dragenter dragleave dragover",function(b){for(var a=
((b.originalEvent||b||"").dataTransfer||{}).types,n=a&&a.length;n--;)~a[n].indexOf("File")&&(b.preventDefault(),e!==b.type&&(e=b.type,"dragleave"!=e&&d.call(b.currentTarget,!0,b),clearTimeout(c),c=setTimeout(function(){d.call(b.currentTarget,"dragleave"!=e,b)},50)))}),j(b,"drop",function(b){b.preventDefault();e=0;d.call(b.currentTarget,!1,b);h.getDropFiles(b,function(d){a.call(b.currentTarget,d,b)})})):h.log("Drag'n'Drop -- not supported")};n&&!n.fn.dnd&&(n.fn.dnd=function(b,d){return this.each(function(){h.event.dnd(this,
b,d)})});a.FileAPI=h.extend(h,a.FileAPI);h.flashUrl||(h.flashUrl=h.staticPath+"FileAPI.flash.swf");h.flashImageUrl||(h.flashImageUrl=h.staticPath+"FileAPI.flash.image.swf")})(window);
(function(a,k,g){function j(a,c){if(!(this instanceof j))return new j(a);this.file=a;this.better=!c;this.matrix={sx:0,sy:0,sw:0,sh:0,dx:0,dy:0,dw:0,dh:0,resize:0,deg:0}}var m=Math.min,f=Math.round,c=!1,e={8:270,3:180,6:90};try{c=-1<k.createElement("canvas").toDataURL("image/png").indexOf("data:image/png")}catch(q){}j.prototype={constructor:j,set:function(c){a.extend(this.matrix,c);return this},crop:function(a,c,e,f){e===g&&(e=a,f=c,a=c=0);return this.set({sx:a,sy:c,sw:e,sh:f||e})},resize:function(a,
c,e){"string"==typeof c&&(e=c,c=a);return this.set({dw:a,dh:c,resize:e})},preview:function(a,c){return this.set({dw:a,dh:c||a,resize:"preview"})},rotate:function(a){return this.set({deg:a})},_load:function(c,e){var f=this;a.readAsImage(c,function(a){e.call(f,"load"!=a.type,a.result)})},_apply:function(a,c){var e=k.createElement("canvas"),f=this.getMatrix(a),g=e.getContext("2d"),m=f.deg,q=f.dw,r=f.dh,v=a.width,p=a.height,j,d=a;if(this.better)for(;2<Math.min(v/q,p/r);)v=~~(v/2+0.5),p=~~(p/2+0.5),j=
k.createElement("canvas"),j.width=v,j.height=p,d!==a?(j.getContext("2d").drawImage(d,0,0,d.width,d.height,0,0,v,p),d=j):(d=j,d.getContext("2d").drawImage(a,f.sx,f.sy,f.sw,f.sh,0,0,v,p),f.sx=f.sy=f.sw=f.sh=0);e.width=!(m%180)?q:r;e.height=m%180?q:r;g.rotate(m*Math.PI/180);g.drawImage(d,f.sx,f.sy,f.sw||d.width,f.sh||d.height,180==m||270==m?-q:0,90==m||180==m?-r:0,q,r);c.call(this,!1,e)},getMatrix:function(c){var e=a.extend({},this.matrix),g=e.sw=e.sw||c.width;c=e.sh=e.sh||c.height;var q=e.dw=e.dw||
e.sw,k=e.dh=e.dh||e.sh,s=g/c,j=q/k,r=e.resize;if("preview"==r){if(q!=g||k!=c)if(j>=s?(s=g,r=s/j):(r=c,s=r*j),s!=g||r!=c)e.sx=~~((g-s)/2),e.sy=~~((c-r)/2),g=s,c=r}else r&&("min"==r?(q=f(s<j?m(g,q):k*s),k=f(s<j?q/s:m(c,k))):(q=f(s>=j?m(g,q):k*s),k=f(s>=j?q/s:m(c,k))));e.sw=g;e.sh=c;e.dw=q;e.dh=k;return e},_trans:function(a){this._load(this.file,function(c,e){c?a(c):this._apply(e,a)})},get:function(c){if(a.support.transform){var f=this;"auto"==f.matrix.deg?a.getInfo(this.file,function(a,g){f.matrix.deg=
e[g&&g.exif&&g.exif.Orientation]||0;f._trans(c)}):f._trans(c)}else c("not_support")},toData:function(a){this.get(a)}};j.exifOrientation=e;j.transform=function(c,e,f,q){a.getInfo(c,function(m,k){var y={},r=a.queue(function(a){q(a,y)});m?r.fail():a.each(e,function(a,e){if(!r.isFail()){var l=j(k.nodeType?k:c);if("function"==typeof a)a(k,l);else if(a.width)l[a.preview?"preview":"resize"](a.width,a.height,a.type);else a.maxWidth&&(k.width>a.maxWidth||k.height>a.maxHeight)&&l.resize(a.maxWidth,a.maxHeight,
"max");a.rotate===g&&f&&(a.rotate="auto");l.rotate(a.rotate);r.inc();l.toData(function(d,a){d?r.fail():(y[e]=a,r.next())})}})})};a.support.canvas=a.support.transform=c;a.Image=j})(FileAPI,document);
(function(a,k,g){var j=k.encodeURIComponent,m=k.FormData;k=function(){this.items=[]};k.prototype={append:function(a,c,e,g){this.items.push({name:a,blob:c&&c.blob||(void 0==c?"":c),file:c&&(e||c.name),type:c&&(g||c.type)})},each:function(a){for(var c=0,e=this.items.length;c<e;c++)a.call(this,this.items[c])},toData:function(f,c){c._chunked=a.support.chunked&&0<c.chunkSize&&1==a.filter(this.items,function(a){return a.file}).length;a.support.html5?this.multipart||!m?(a.log("FileAPI.Form.toMultipartData"),
this.toMultipartData(f)):c._chunked?(a.log("FileAPI.Form.toPlainData"),this.toPlainData(f)):(a.log("FileAPI.Form.toFormData"),this.toFormData(f)):(a.log("FileAPI.Form.toHtmlData"),this.toHtmlData(f))},_to:function(f,c,e,g){var m=a.queue(function(){c(f)});this.each(function(a){e(a,f,m,g)});m.check()},toHtmlData:function(f){this._to(g.createDocumentFragment(),f,function(c,e){var f=c.blob,m;c.file?(a.reset(f),f.name=c.name,e.appendChild(f)):(m=g.createElement("input"),m.name=c.name,m.type="hidden",m.value=
f,e.appendChild(m))})},toPlainData:function(a){this._to({},a,function(a,e,f){a.file&&(e.type=a.file);a.blob.toBlob?(f.inc(),a.blob.toBlob(function(g){e.name=a.name;e.file=g;e.size=g.length;e.type=a.type;f.next()},"image/png")):a.file?(e.name=a.blob.name,e.file=a.blob,e.size=a.blob.size,e.type=a.type):(e.params||(e.params=[]),e.params.push(encodeURIComponent(a.name)+"="+encodeURIComponent(a.blob)));e.start=-1;e.end=e.file.FileAPIReadPosition||-1;e.retry=0})},toFormData:function(a){this._to(new m,a,
function(a,e,f){a.file&&e.append("_"+a.name,a.file);a.blob&&a.blob.toBlob?(f.inc(),a.blob.toBlob(function(g){e.append(a.name,g,a.file);f.next()},"image/png")):a.file?e.append(a.name,a.blob,a.file):e.append(a.name,a.blob)})},toMultipartData:function(f){this._to([],f,function(c,e,f,g){var l=!!c.file,m=c.blob,k=function(a){e.push("--_"+g+('\r\nContent-Disposition: form-data; name="'+c.name+'"'+(l?'; filename="'+j(c.file)+'"':"")+(l?"\r\nContent-Type: "+(c.type||"application/octet-stream"):"")+"\r\n\r\n"+
(l?a:j(a))+"\r\n"));f.next()};f.inc();a.isFile(m)?a.readAsBinaryString(m,function(a){"load"==a.type&&k(a.result)}):k(m)},a.expando)}};a.Form=k})(FileAPI,window,document);
(function(a,k){var g=function(){},j=function(a){this.uid=k.uid();this.xhr={abort:g,getResponseHeader:g,getAllResponseHeaders:g};this.options=a};j.prototype={status:0,statusText:"",getResponseHeader:function(a){return this.xhr.getResponseHeader(a)},getAllResponseHeaders:function(){return this.xhr.getAllResponseHeaders()||{}},end:function(m,f){var c=this,e=c.options;c.end=c.abort=g;c.status=m;f&&(c.statusText=f);k.log("xhr.end:",m,f);e.complete(200==m||201==m?!1:c.statusText||"unknown",c);c.xhr&&c.xhr.node&&
setTimeout(function(){var e=c.xhr.node;try{e.parentNode.removeChild(e)}catch(f){}try{delete a[c.uid]}catch(g){}a[c.uid]=c.xhr.node=null},9)},abort:function(){this.end(0,"abort");this.xhr&&(this.xhr.aborted=!0,this.xhr.abort())},send:function(a){var f=this,c=this.options;a.toData(function(a){c.upload(c,f);f._send.call(f,c,a)},c)},_send:function(g,f){var c=this,e,q=c.uid,j=g.url;k.log("XHR._send:",f);j+=(~j.indexOf("?")?"&":"?")+k.uid();f.nodeName?(g.upload(g,c),e=document.createElement("div"),e.innerHTML=
'<form target="'+q+'" action="'+j+'" method="POST" enctype="multipart/form-data" style="position: absolute; top: -1000px; overflow: hidden; width: 1px; height: 1px;"><iframe name="'+q+'" src="javascript:false;"></iframe><input value="'+q+'" name="callback" type="hidden"/></form>',c.xhr.abort=function(){var a=e.getElementsByName("iframe")[0];if(a)try{a.stop?a.stop():a.contentWindow.stop?a.contentWindow.stop():a.contentWindow.document.execCommand("Stop")}catch(c){}e=null},j=e.getElementsByTagName("form")[0],
j.appendChild(f),k.log(j.parentNode.innerHTML),document.body.appendChild(e),c.xhr.node=e,a[q]=function(a,f,g){c.readyState=4;c.responseText=g;c.end(a,f);e=null},c.readyState=2,j.submit(),j=null):this.xhr&&this.xhr.aborted?k.log("Error: already aborted"):(e=c.xhr=k.getXHR(),f.params&&(j+=(0>j.indexOf("?")?"?":"&")+f.params.join("&")),e.open("POST",j,!0),k.withCredentials&&(e.withCredentials="true"),(!g.headers||!g.headers["X-Requested-With"])&&e.setRequestHeader("X-Requested-With","XMLHttpRequest"),
k.each(g.headers,function(a,c){e.setRequestHeader(c,a)}),g._chunked?(e.upload&&e.upload.addEventListener("progress",function(a){f.retry||g.progress({type:a.type,total:f.size,loaded:f.start+a.loaded,totalSize:f.size},c,g)},!1),e.onreadystatechange=function(){c.status=e.status;c.statusText=e.statusText;c.readyState=e.readyState;if(4==e.readyState){for(var a in{"":1,XML:1,Text:1,Body:1})c["response"+a]=e["response"+a];e.onreadystatechange=null;if(!e.status||0<e.status-201)if(k.log("Error: "+e.status),
(!e.status&&!e.aborted||500==e.status||416==e.status)&&++f.retry<=g.chunkUploadRetry){a=e.status?0:k.chunkNetworkDownRetryTimeout;g.pause(f.file,g);var j=parseInt(e.getResponseHeader("X-Last-Known-Byte"),10);k.log("X-Last-Known-Byte: "+j);f.end=j?j:f.start-1;setTimeout(function(){c._send(g,f)},a)}else c.end(e.status);else f.retry=0,f.end==f.size-1?c.end(e.status):(j=parseInt(e.getResponseHeader("X-Last-Known-Byte"),10),k.log("X-Last-Known-Byte: "+j),j&&(f.end=j),f.file.FileAPIReadPosition=f.end,setTimeout(function(){c._send(g,
f)},0));e=null}},f.start=f.end+1,f.end=Math.max(Math.min(f.start+g.chunkSize,f.size)-1,f.start),(q="slice")in f.file||(q="mozSlice")in f.file||(q="webkitSlice"),e.setRequestHeader("Content-Range","bytes "+f.start+"-"+f.end+"/"+f.size),e.setRequestHeader("Content-Disposition","attachment; filename="+encodeURIComponent(f.name)),e.setRequestHeader("Content-Type",f.type||"application/octet-stream"),q=f.file[q](f.start,f.end+1),e.send(q),q=null):(e.upload&&e.upload.addEventListener("progress",k.throttle(function(a){g.progress(a,
c,g)},100),!1),e.onreadystatechange=function(){c.status=e.status;c.statusText=e.statusText;c.readyState=e.readyState;if(4==e.readyState){for(var a in{"":1,XML:1,Text:1,Body:1})c["response"+a]=e["response"+a];e.onreadystatechange=null;c.end(e.status);e=null}},k.isArray(f)?(e.setRequestHeader("Content-Type","multipart/form-data; boundary=_"+k.expando),f=f.join("")+"--_"+k.expando+"--",e.sendAsBinary?e.sendAsBinary(f):(q=Array.prototype.map.call(f,function(a){return a.charCodeAt(0)&255}),e.send((new Uint8Array(q)).buffer))):
e.send(f)))}};k.XHR=j})(window,FileAPI);
(function(a,k,g){var j=a.support,m=k.navigator,f=m.mimeTypes,c=!1;if(m.plugins&&"object"==typeof m.plugins["Shockwave Flash"])c=m.plugins["Shockwave Flash"].description&&!(f&&f["application/x-shockwave-flash"]&&!f["application/x-shockwave-flash"].enabledPlugin);else try{c=!(!k.ActiveXObject||!new ActiveXObject("ShockwaveFlash.ShockwaveFlash"))}catch(e){a.log("ShockwaveFlash.ShockwaveFlash -- does not supported.")}j.flash=c;if(a.support.flash&&(!a.html5||!a.support.html5||a.cors&&!a.support.cors)){var q=
function(a){return('<object id="#id#" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" width="'+(a.width||"100%")+'" height="'+(a.height||"100%")+'"><param name="movie" value="#src#" /><param name="flashvars" value="#flashvars#" /><param name="swliveconnect" value="true" /><param name="allowscriptaccess" value="always" /><param name="allownetworking" value="all" /><param name="menu" value="false" /><param name="wmode" value="#wmode#" /><embed flashvars="#flashvars#" swliveconnect="true" allownetworking="all" allowscriptaccess="always" name="#id#" src="#src#" width="'+
(a.width||"100%")+'" height="'+(a.height||"100%")+'" menu="false" wmode="transparent" type="application/x-shockwave-flash"></embed></object>').replace(/#(\w+)#/ig,function(c,e){return a[e]})},t=function(a,c){if(a&&a.style){var e,f;for(e in c){f=c[e];"number"==typeof f&&(f+="px");try{a.style[e]=f}catch(g){}}}},l=function(d,c){a.each(c,function(a,c){var e=d[c];d[c]=function(){this.parent=e;return a.apply(this,arguments)}})},A=function(d){var c=d.wid=a.uid();p._fn[c]=d;return"FileAPI.Flash._fn."+c},
u=function(a){try{p._fn[a.wid]=null,delete p._fn[a.wid]}catch(c){}},C=function(a,c){if(!v.test(a)){if(/^\.\//.test(a)||"/"!=a.charAt(0)){var e=location.pathname,e=e.substr(0,e.lastIndexOf("/"));a=(e+"/"+a).replace("/./","/")}"//"!=a.substr(0,2)&&(a="//"+location.host+a);v.test(a)||(a=location.protocol+a)}c&&(a+=(/\?/.test(a)?"&":"?")+c);return a},s=a.uid(),y=0,r={},v=/^https?:/i,p={_fn:{},init:function(){var d=g.body&&g.body.firstChild;if(d){do if(1==d.nodeType){a.log("FlashAPI.Flash.init...");var c=
g.createElement("div");t(c,{top:1,right:1,width:5,height:5,position:"absolute"});d.parentNode.insertBefore(c,d);p.publish(c,s);return}while(d=d.nextSibling)}10>y&&setTimeout(p.init,50*++y)},publish:function(d,c){d.innerHTML=q({id:c,src:C(a.flashUrl,"r="+a.version),wmode:"transparent",flashvars:"callback=FileAPI.Flash.event&flashId="+c+"&storeKey="+navigator.userAgent.match(/\d/ig).join("")+"_"+a.version+(p.isReady||(a.pingUrl?"&ping="+a.pingUrl:""))})},ready:function(){p.ready=a.F;p.isReady=!0;p.patch();
a.event.on(g,"mouseover",p.mouseover);a.event.on(g,"click",function(a){p.mouseover(a)&&(a.preventDefault?a.preventDefault():a.returnValue=!0)})},getWrapper:function(a){do if(/js-fileapi-wrapper/.test(a.className))return a;while((a=a.parentNode)&&a!==g.body)},mouseover:function(d){d=a.event.fix(d).target;if(/input/i.test(d.nodeName)&&"file"==d.type){var c=d.getAttribute(s);if("i"==c||"r"==c)return!1;if("p"!=c){d.setAttribute(s,"i");var c=g.createElement("div"),e=p.getWrapper(d);if(!e){a.log("flash.mouseover.error: js-fileapi-wrapper not found");
return}t(c,{top:0,left:0,width:d.offsetWidth+100,height:d.offsetHeight+100,zIndex:"1000000",position:"absolute"});e.appendChild(c);p.publish(c,a.uid());d.setAttribute(s,"p")}return!0}},event:function(d){var c=d.type;if("ready"==c){try{p.getInput(d.flashId).setAttribute(s,"r")}catch(e){}p.ready();setTimeout(function(){p.mouseenter(d)},50);return!0}"ping"===c?a.log("(flash -> js).ping:",[d.status,d.savedStatus],d.error):"log"===c?a.log("(flash -> js).log:",d.target):c in p&&setTimeout(function(){a.log("Flash.event."+
d.type+":",d);p[c](d)},1)},mouseenter:function(d){var c=p.getInput(d.flashId);if(c){p.cmd(d,"multiple",null!=c.getAttribute("multiple"));var e=[],f={};a.each((c.getAttribute("accept")||"").split(/,\s*/),function(d){a.accept[d]&&a.each(a.accept[d].split(" "),function(a){f[a]=1})});a.each(f,function(a,d){e.push(d)});p.cmd(d,"accept",e.length?e.join(",")+","+e.join(",").toUpperCase():"*")}},get:function(a){return g[a]||k[a]||g.embeds[a]},getInput:function(d){try{var c=p.getWrapper(p.get(d));if(c)return c.getElementsByTagName("input")[0]}catch(e){a.log('Can not find "input" by flashId:',
d,e)}},select:function(d){var c=p.getInput(d.flashId),e=a.uid(c);d=d.target.files;a.each(d,function(d){a.checkFileObj(d)});r[e]=d;g.createEvent?(e=g.createEvent("Event"),e.initEvent("change",!0,!1),c.dispatchEvent(e)):g.createEventObject&&(e=g.createEventObject(),c.fireEvent("onchange",e))},cmd:function(d,c,e,f){try{return a.log("(js -> flash)."+c+":",e),p.get(d.flashId||d).cmd(c,e)}catch(g){a.log("(js -> flash).onError:",g),f||setTimeout(function(){p.cmd(d,c,e,!0)},50)}},patch:function(){a.flashEngine=
a.support.transform=!0;l(a,{getFiles:function(d,c,e){if(e)return a.filterFiles(a.getFiles(d),c,e),null;var f=a.isArray(d)?d:r[a.uid(d.target||d.srcElement||d)];if(!f)return this.parent.apply(this,arguments);c&&(c=a.getFilesFilter(c),f=a.filter(f,function(a){return c.test(a.name)}));return f},getInfo:function(d,c){if(d&&!d.flashId)this.parent.apply(this,arguments);else{if(!d.__info){var e=d.__info=a.defer();p.cmd(d,"getFileInfo",{id:d.id,callback:A(function F(a,c){u(F);e.resolve(a,d.info=c)})})}d.__info.then(c)}}});
a.support.transform=!0;a.Image&&l(a.Image.prototype,{get:function(a,c){this.set({scaleMode:c||"noScale"});this.parent(a)},_load:function(d,c){a.log("FileAPI.Image._load:",d);if(d&&!d.flashId)this.parent.apply(this,arguments);else{var e=this;a.getInfo(d,function(a){c.call(e,a,d)})}},_apply:function(d,c){a.log("FileAPI.Image._apply:",d);if(d&&!d.flashId)this.parent.apply(this,arguments);else{var e=this.getMatrix(d.info);p.cmd(d,"imageTransform",{id:d.id,matrix:e,callback:A(function F(f,k){a.log("FileAPI.Image._apply.callback:",
f);u(F);if(f)c(f);else if(!a.support.dataURI||3E4<k.length){var j={width:!(e.deg%180)?e.dw:e.dh,height:e.deg%180?e.dw:e.dh,scale:e.scaleMode},l=c,m=function(){try{p.get(s).setImage(k)}catch(d){a.log('flash.setImage -- can not set "base64":',d)}},r,s=a.uid(),z=g.createElement("div");for(r in j)z.setAttribute("data-img-"+r,j[r]);t(z,j);z.innerHTML=q(a.extend({id:s,src:C(a.flashImageUrl,"r="+a.uid()),wmode:"opaque",flashvars:"scale="+j.scale+"&callback="+A(function J(){u(J);setTimeout(m,99);return!0})},
j));l(!1,z);z=null}else{var v=new Image;a.event.one(v,"error abort load",function(a){c("load"!=a.type&&a.type,v);v=null});v.src="data:"+d.type+";base64,"+k}})})}},toData:function(d){var c=this.file,e=c.info,f=this.getMatrix(e);c&&!c.flashId?this.parent.apply(this,arguments):("auto"==f.deg&&(f.deg=a.Image.exifOrientation[e&&e.exif&&e.exif.Orientation]||0),d.call(this,!c.info,{id:c.id,flashId:c.flashId,name:c.name,type:c.type,matrix:f}))}});l(a.Form.prototype,{toData:function(d){for(var c=this.items,
e=c.length;e--;)if(c[e].file&&c[e].blob&&!c[e].blob.flashId)return this.parent.apply(this,arguments);a.log("flash.Form.toData");d(c)}});l(a.XHR.prototype,{_send:function(c,e){if(e.nodeName||e.append&&a.support.html5||a.isArray(e)&&"string"===typeof e[0])return this.parent.apply(this,arguments);var f={},g={},j=this,k,l;a.each(e,function(a){a.file?(g[a.name]=a={id:a.blob.id,name:a.blob.name,matrix:a.blob.matrix,flashId:a.blob.flashId},l=a.id,k=a.flashId):f[a.name]=a.blob});if(!l&&!k)return this.parent.apply(this,
arguments);a.log("flash.XHR._send:",k,l,g);j.xhr={headers:{},abort:function(){p.cmd(k,"abort",{id:l})},getResponseHeader:function(a){return this.headers[a]},getAllResponseHeaders:function(){return this.headers}};var m=a.queue(function(){p.cmd(k,"upload",{url:C(c.url),data:f,files:g,headers:c.headers,callback:A(function I(e){var f=e.type,g=e.result;a.log("flash.upload."+f+":",e);if("progress"==f)e.loaded=Math.min(e.loaded,e.total),e.lengthComputable=!0,c.progress(e);else if("complete"==f)u(I),"string"==
typeof g&&(j.responseText=g.replace(/%22/g,'"').replace(/%5c/g,"\\").replace(/%26/g,"&").replace(/%25/g,"%")),j.end(e.status||200);else if("abort"==f||"error"==f)j.end(e.status||0,e.message),u(I)})})});a.each(g,function(c){m.inc();a.getInfo(c,m.next)});m.check()}})}};a.Flash=p;var w=new Image;a.event.one(w,"error load",function(){a.support.dataURI=!(1!=w.width||1!=w.height);w=null;p.init()});w.src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw=="}})(FileAPI,window,document);
"undefined"!==typeof ajs&&ajs.loaded&&ajs.loaded("{fileapi}FileAPI.min");"function"===typeof define&&define.amd&&define("FileAPI",[],function(){return window.FileAPI||{}});