package com.salesmanager.core.business.customer.service.attribute;

import java.util.List;

import com.salesmanager.core.business.customer.model.attribute.CustomerOptionValue;
import com.salesmanager.core.business.generic.exception.ServiceException;
import com.salesmanager.core.business.generic.service.SalesManagerEntityService;
import com.salesmanager.core.business.merchant.model.MerchantStore;
import com.salesmanager.core.business.reference.language.model.Language;

public interface CustomerOptionValueService extends SalesManagerEntityService<Long, CustomerOptionValue> {



	List<CustomerOptionValue> listByStore(MerchantStore store, Language language)
			throws ServiceException;

	void saveOrUpdate(CustomerOptionValue entity) throws ServiceException;

	CustomerOptionValue getByCode(MerchantStore store, String optionValueCode);



}
