/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.shopizer.search.services.GetResponse;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.services.worker.ExecutionContext;
import com.shopizer.search.services.worker.IndexWorker;
import com.shopizer.search.utils.FileUtil;
import com.shopizer.search.utils.IndexConfiguration;
import com.shopizer.search.utils.SearchClient;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ObjectIndexerImpl
implements IndexWorker {
    private static boolean init = false;
    @Inject
    private SearchDelegate searchDelegate;
    private List<IndexConfiguration> indexConfigurations;
    private static Logger log = Logger.getLogger(ObjectIndexerImpl.class);

    public List<IndexConfiguration> getIndexConfigurations() {
        return this.indexConfigurations;
    }

    public void setIndexConfigurations(List<IndexConfiguration> indexConfigurations) {
        this.indexConfigurations = indexConfigurations;
    }

    @Override
    public synchronized void init(SearchClient client) {
        if (init) {
            return;
        }
        init = true;
        if (this.getIndexConfigurations() != null && this.getIndexConfigurations().size() > 0) {
            Iterator<IndexConfiguration> iterator = this.indexConfigurations.iterator();
            while (iterator.hasNext()) {
                IndexConfiguration o;
                IndexConfiguration config = o = iterator.next();
                String mappingFile = null;
                String settingsFile = null;
                if (!StringUtils.isBlank((CharSequence)config.getMappingFileName())) {
                    mappingFile = config.getMappingFileName();
                }
                if (!StringUtils.isBlank((CharSequence)config.getSettingsFileName())) {
                    settingsFile = config.getSettingsFileName();
                }
                if (mappingFile == null && settingsFile == null) continue;
                String metadata = null;
                String settingsdata = null;
                try {
                    if (mappingFile != null) {
                        metadata = FileUtil.readFileAsString(mappingFile);
                    }
                    if (settingsFile != null) {
                        settingsdata = FileUtil.readFileAsString(settingsFile);
                    }
                    if (StringUtils.isBlank((CharSequence)config.getIndexName()) || this.searchDelegate.indexExist(config.getCollectionName())) continue;
                    this.searchDelegate.createIndice(metadata, settingsdata, config.getCollectionName(), config.getIndexName());
                }
                catch (Exception e) {
                    log.error((Object)e);
                    log.error((Object)"*********************************************");
                    log.error((Object)e);
                    log.error((Object)"*********************************************");
                    init = false;
                }
            }
        }
    }

    @Override
    public void execute(SearchClient client, String json, String collection, String object, String id, ExecutionContext context) throws Exception {
        try {
            Map indexData;
            if (!init) {
                this.init(client);
            }
            if ((indexData = (Map)context.getObject("indexData")) == null) {
                ObjectMapper mapper = new ObjectMapper();
                indexData = (Map)mapper.readValue(json, Map.class);
            }
            if (context == null) {
                context = new ExecutionContext();
            }
            context.setObject("indexData", indexData);
            GetResponse r = this.searchDelegate.getObject(collection, object, id);
            if (r != null) {
                this.searchDelegate.delete(collection, object, id);
            }
            this.searchDelegate.index(json, collection, object, id);
        }
        catch (Exception e) {
            log.error((Object)"Exception while indexing a product, maybe a timing ussue for no shards available", (Throwable)e);
        }
    }
}

