/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.utils;

import com.shopizer.search.utils.ServerConfiguration;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.node.Node;

public class SearchClient {
    private static Logger log = Logger.getLogger(SearchClient.class);
    private JestClient client = null;
    private Node node = null;
    private boolean init = false;
    private ServerConfiguration serverConfiguration = null;
    private String authenticationHeader = null;

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void setServerConfiguration(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public JestClient getClient() {
        if (!this.init) {
            this.initClient();
        }
        return this.client;
    }

    public void stopClient() {
        if (this.node != null) {
            this.node.close();
        }
    }

    private synchronized void initClient() {
        if (this.client == null) {
            try {
                StringBuilder host = new StringBuilder().append(this.getServerConfiguration().getClusterHost()).append(":").append(this.getServerConfiguration().getClusterPort());
                JestClientFactory factory = new JestClientFactory();
                factory.setHttpClientConfig(((HttpClientConfig.Builder)new HttpClientConfig.Builder(host.toString()).multiThreaded(true)).build());
                this.client = factory.getObject();
                if (!StringUtils.isBlank((CharSequence)this.getServerConfiguration().getProxyUser()) && !StringUtils.isBlank((CharSequence)this.getServerConfiguration().getProxyPassword())) {
                    this.setAuthenticationHeader("Basic " + new String(Base64.encodeBase64((byte[])String.format("%s:%s", this.getServerConfiguration().getProxyUser(), this.getServerConfiguration().getProxyPassword()).getBytes())));
                }
                log.debug((Object)"****** ES client ready ********");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getAuthenticationHeader() {
        return this.authenticationHeader;
    }

    public void setAuthenticationHeader(String authenticationHeader) {
        this.authenticationHeader = authenticationHeader;
    }
}

