/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.workflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.shopizer.search.services.worker.ExecutionContext;
import com.shopizer.search.services.worker.IndexWorker;
import com.shopizer.search.services.workflow.Workflow;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class IndexWorkflow
extends Workflow {
    private static Logger log = Logger.getLogger(IndexWorkflow.class);
    private List indexWorkflow;

    public List getIndexWorkflow() {
        return this.indexWorkflow;
    }

    public void setIndexWorkflow(List indexWorkflow) {
        this.indexWorkflow = indexWorkflow;
    }

    public void index(String json, String collection, String object) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map indexData = (Map)mapper.readValue(json, Map.class);
        String _id = (String)indexData.get("id");
        if (StringUtils.isBlank((CharSequence)_id)) {
            log.warn((Object)("No id exist for object " + json + " will create a generic one"));
            UUID uid = UUID.randomUUID();
            _id = uid.toString();
            indexData.put("id", _id);
            json = mapper.writeValueAsString((Object)indexData);
        }
        ExecutionContext context = new ExecutionContext();
        context.setObject("indexData", indexData);
        if (this.indexWorkflow != null) {
            for (Object o : this.indexWorkflow) {
                IndexWorker iw = (IndexWorker)o;
                iw.execute(this.getSearchClient(), json, collection, object, _id, context);
            }
        }
    }
}

