/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.executor;

import azkaban.database.AzkabanDataSource;
import azkaban.database.DataSourceUtils;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionReference;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.test.executor.JdbcExecutorLoaderTest;
import azkaban.utils.FileIOUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcExecutorLoaderTest {
    private static boolean testDBExists;
    private static final String host = "cyu-ld.linkedin.biz";
    private static final int port = 3306;
    private static final String database = "azkaban2";
    private static final String user = "azkaban";
    private static final String password = "azkaban";
    private static final int numConnections = 10;
    private File flowDir = new File("unit/executions/exectest1");

    @BeforeClass
    public static void setupDB() {
        AzkabanDataSource dataSource = DataSourceUtils.getMySQLDataSource((String)"cyu-ld.linkedin.biz", (Integer)3306, (String)"azkaban2", (String)"azkaban", (String)"azkaban", (Integer)10);
        testDBExists = true;
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        CountHandler countHandler = new CountHandler();
        QueryRunner runner = new QueryRunner();
        try {
            runner.query(connection, "SELECT COUNT(1) FROM active_executing_flows", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM execution_flows", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM execution_jobs", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.query(connection, "SELECT COUNT(1) FROM execution_logs", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        DbUtils.closeQuietly((Connection)connection);
        JdbcExecutorLoaderTest.clearDB();
    }

    private static void clearDB() {
        if (!testDBExists) {
            return;
        }
        AzkabanDataSource dataSource = DataSourceUtils.getMySQLDataSource((String)"cyu-ld.linkedin.biz", (Integer)3306, (String)"azkaban2", (String)"azkaban", (String)"azkaban", (Integer)10);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, "DELETE FROM active_executing_flows");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM execution_flows");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM execution_jobs");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        try {
            runner.update(connection, "DELETE FROM execution_logs");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        DbUtils.closeQuietly((Connection)connection);
    }

    @Test
    public void testUploadExecutionFlows() throws Exception {
        if (!this.isTestSetup()) {
            return;
        }
        ExecutorLoader loader = this.createLoader();
        ExecutableFlow flow = this.createExecutableFlow("exec1");
        loader.uploadExecutableFlow(flow);
        ExecutableFlow fetchFlow = loader.fetchExecutableFlow(flow.getExecutionId());
        Assert.assertTrue((flow != fetchFlow ? 1 : 0) != 0);
        Assert.assertEquals((long)flow.getExecutionId(), (long)fetchFlow.getExecutionId());
        Assert.assertEquals((long)flow.getEndTime(), (long)fetchFlow.getEndTime());
        Assert.assertEquals((long)flow.getStartTime(), (long)fetchFlow.getStartTime());
        Assert.assertEquals((long)flow.getSubmitTime(), (long)fetchFlow.getSubmitTime());
        Assert.assertEquals((Object)flow.getFlowId(), (Object)fetchFlow.getFlowId());
        Assert.assertEquals((long)flow.getProjectId(), (long)fetchFlow.getProjectId());
        Assert.assertEquals((long)flow.getVersion(), (long)fetchFlow.getVersion());
        Assert.assertEquals((Object)flow.getExecutionOptions().getFailureAction(), (Object)fetchFlow.getExecutionOptions().getFailureAction());
        Assert.assertEquals(new HashSet(flow.getEndNodes()), new HashSet(fetchFlow.getEndNodes()));
    }

    @Test
    public void testUpdateExecutionFlows() throws Exception {
        if (!this.isTestSetup()) {
            return;
        }
        ExecutorLoader loader = this.createLoader();
        ExecutableFlow flow = this.createExecutableFlow("exec1");
        loader.uploadExecutableFlow(flow);
        ExecutableFlow fetchFlow2 = loader.fetchExecutableFlow(flow.getExecutionId());
        fetchFlow2.setEndTime(System.currentTimeMillis());
        fetchFlow2.setStatus(Status.SUCCEEDED);
        loader.updateExecutableFlow(fetchFlow2);
        ExecutableFlow fetchFlow = loader.fetchExecutableFlow(flow.getExecutionId());
        Assert.assertTrue((flow != fetchFlow ? 1 : 0) != 0);
        Assert.assertEquals((long)flow.getExecutionId(), (long)fetchFlow.getExecutionId());
        Assert.assertEquals((long)fetchFlow2.getEndTime(), (long)fetchFlow.getEndTime());
        Assert.assertEquals((Object)fetchFlow2.getStatus(), (Object)fetchFlow.getStatus());
        Assert.assertEquals((long)flow.getStartTime(), (long)fetchFlow.getStartTime());
        Assert.assertEquals((long)flow.getSubmitTime(), (long)fetchFlow.getSubmitTime());
        Assert.assertEquals((Object)flow.getFlowId(), (Object)fetchFlow.getFlowId());
        Assert.assertEquals((long)flow.getProjectId(), (long)fetchFlow.getProjectId());
        Assert.assertEquals((long)flow.getVersion(), (long)fetchFlow.getVersion());
        Assert.assertEquals((Object)flow.getExecutionOptions().getFailureAction(), (Object)fetchFlow.getExecutionOptions().getFailureAction());
        Assert.assertEquals(new HashSet(flow.getEndNodes()), new HashSet(fetchFlow.getEndNodes()));
    }

    @Test
    public void testUploadExecutableNode() throws Exception {
        if (!this.isTestSetup()) {
            return;
        }
        ExecutorLoader loader = this.createLoader();
        ExecutableFlow flow = this.createExecutableFlow(10, "exec1");
        flow.setExecutionId(10);
        File jobFile = new File(this.flowDir, "job10.job");
        Props props = new Props(null, jobFile);
        props.put("test", "test2");
        ExecutableNode oldNode = flow.getExecutableNode("job10");
        oldNode.setStartTime(System.currentTimeMillis());
        loader.uploadExecutableNode(oldNode, props);
        ExecutableJobInfo info = loader.fetchJobInfo(10, "job10", 0);
        Assert.assertEquals((long)flow.getExecutionId(), (long)info.getExecId());
        Assert.assertEquals((long)flow.getProjectId(), (long)info.getProjectId());
        Assert.assertEquals((long)flow.getVersion(), (long)info.getVersion());
        Assert.assertEquals((Object)flow.getFlowId(), (Object)info.getFlowId());
        Assert.assertEquals((Object)oldNode.getId(), (Object)info.getJobId());
        Assert.assertEquals((Object)oldNode.getStatus(), (Object)info.getStatus());
        Assert.assertEquals((long)oldNode.getStartTime(), (long)info.getStartTime());
        Assert.assertEquals((String)("endTime = " + oldNode.getEndTime() + " info endTime = " + info.getEndTime()), (long)oldNode.getEndTime(), (long)info.getEndTime());
        Props outputProps = new Props();
        outputProps.put("hello", "output");
        oldNode.setOutputProps(outputProps);
        oldNode.setEndTime(System.currentTimeMillis());
        loader.updateExecutableNode(oldNode);
        Props fInputProps = loader.fetchExecutionJobInputProps(10, "job10");
        Props fOutputProps = loader.fetchExecutionJobOutputProps(10, "job10");
        Pair inOutProps = loader.fetchExecutionJobProps(10, "job10");
        Assert.assertEquals((Object)fInputProps.get((Object)"test"), (Object)"test2");
        Assert.assertEquals((Object)fOutputProps.get((Object)"hello"), (Object)"output");
        Assert.assertEquals((Object)((Props)inOutProps.getFirst()).get((Object)"test"), (Object)"test2");
        Assert.assertEquals((Object)((Props)inOutProps.getSecond()).get((Object)"hello"), (Object)"output");
    }

    @Test
    public void testActiveReference() throws Exception {
        if (!this.isTestSetup()) {
            return;
        }
        ExecutorLoader loader = this.createLoader();
        ExecutableFlow flow1 = this.createExecutableFlow("exec1");
        loader.uploadExecutableFlow(flow1);
        ExecutionReference ref1 = new ExecutionReference(flow1.getExecutionId(), "test", 1);
        loader.addActiveExecutableReference(ref1);
        ExecutableFlow flow2 = this.createExecutableFlow("exec1");
        loader.uploadExecutableFlow(flow2);
        ExecutionReference ref2 = new ExecutionReference(flow2.getExecutionId(), "test", 1);
        loader.addActiveExecutableReference(ref2);
        ExecutableFlow flow3 = this.createExecutableFlow("exec1");
        loader.uploadExecutableFlow(flow3);
        Map activeFlows1 = loader.fetchActiveFlows();
        ExecutableFlow flow1Result = (ExecutableFlow)((Pair)activeFlows1.get(flow1.getExecutionId())).getSecond();
        Assert.assertNotNull((Object)flow1Result);
        Assert.assertTrue((flow1 != flow1Result ? 1 : 0) != 0);
        Assert.assertEquals((long)flow1.getExecutionId(), (long)flow1Result.getExecutionId());
        Assert.assertEquals((long)flow1.getEndTime(), (long)flow1Result.getEndTime());
        Assert.assertEquals((long)flow1.getStartTime(), (long)flow1Result.getStartTime());
        Assert.assertEquals((long)flow1.getSubmitTime(), (long)flow1Result.getSubmitTime());
        Assert.assertEquals((Object)flow1.getFlowId(), (Object)flow1Result.getFlowId());
        Assert.assertEquals((long)flow1.getProjectId(), (long)flow1Result.getProjectId());
        Assert.assertEquals((long)flow1.getVersion(), (long)flow1Result.getVersion());
        Assert.assertEquals((Object)flow1.getExecutionOptions().getFailureAction(), (Object)flow1Result.getExecutionOptions().getFailureAction());
        ExecutableFlow flow1Result2 = (ExecutableFlow)((Pair)activeFlows1.get(flow2.getExecutionId())).getSecond();
        Assert.assertNotNull((Object)flow1Result2);
        Assert.assertTrue((flow2 != flow1Result2 ? 1 : 0) != 0);
        Assert.assertEquals((long)flow2.getExecutionId(), (long)flow1Result2.getExecutionId());
        Assert.assertEquals((long)flow2.getEndTime(), (long)flow1Result2.getEndTime());
        Assert.assertEquals((long)flow2.getStartTime(), (long)flow1Result2.getStartTime());
        Assert.assertEquals((long)flow2.getSubmitTime(), (long)flow1Result2.getSubmitTime());
        Assert.assertEquals((Object)flow2.getFlowId(), (Object)flow1Result2.getFlowId());
        Assert.assertEquals((long)flow2.getProjectId(), (long)flow1Result2.getProjectId());
        Assert.assertEquals((long)flow2.getVersion(), (long)flow1Result2.getVersion());
        Assert.assertEquals((Object)flow2.getExecutionOptions().getFailureAction(), (Object)flow1Result2.getExecutionOptions().getFailureAction());
        loader.removeActiveExecutableReference(flow2.getExecutionId());
        Map activeFlows2 = loader.fetchActiveFlows();
        Assert.assertTrue((boolean)activeFlows2.containsKey(flow1.getExecutionId()));
        Assert.assertFalse((boolean)activeFlows2.containsKey(flow3.getExecutionId()));
        Assert.assertFalse((boolean)activeFlows2.containsKey(flow2.getExecutionId()));
    }

    @Test
    public void testSmallUploadLog() throws ExecutorManagerException {
        File logDir = new File("unit/executions/logtest");
        File[] smalllog = new File[]{new File(logDir, "log1.log"), new File(logDir, "log2.log"), new File(logDir, "log3.log")};
        ExecutorLoader loader = this.createLoader();
        loader.uploadLogFile(1, "smallFiles", 0, smalllog);
        FileIOUtils.LogData data = loader.fetchLogs(1, "smallFiles", 0, 0, 50000);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((String)("Logs length is " + data.getLength()), (long)data.getLength(), (long)53L);
        System.out.println(data.toString());
        FileIOUtils.LogData data2 = loader.fetchLogs(1, "smallFiles", 0, 10, 20);
        System.out.println(data2.toString());
        Assert.assertNotNull((Object)data2);
        Assert.assertEquals((String)("Logs length is " + data2.getLength()), (long)data2.getLength(), (long)20L);
    }

    @Test
    public void testLargeUploadLog() throws ExecutorManagerException {
        File logDir = new File("unit/executions/logtest");
        File[] largelog = new File[]{new File(logDir, "largeLog1.log"), new File(logDir, "largeLog2.log"), new File(logDir, "largeLog3.log")};
        ExecutorLoader loader = this.createLoader();
        loader.uploadLogFile(1, "largeFiles", 0, largelog);
        FileIOUtils.LogData logsResult = loader.fetchLogs(1, "largeFiles", 0, 0, 64000);
        Assert.assertNotNull((Object)logsResult);
        Assert.assertEquals((String)("Logs length is " + logsResult.getLength()), (long)logsResult.getLength(), (long)64000L);
        FileIOUtils.LogData logsResult2 = loader.fetchLogs(1, "largeFiles", 0, 1000, 64000);
        Assert.assertNotNull((Object)logsResult2);
        Assert.assertEquals((String)("Logs length is " + logsResult2.getLength()), (long)logsResult2.getLength(), (long)64000L);
        FileIOUtils.LogData logsResult3 = loader.fetchLogs(1, "largeFiles", 0, 330000, 400000);
        Assert.assertNotNull((Object)logsResult3);
        Assert.assertEquals((String)("Logs length is " + logsResult3.getLength()), (long)logsResult3.getLength(), (long)5493L);
        FileIOUtils.LogData logsResult4 = loader.fetchLogs(1, "largeFiles", 0, 340000, 400000);
        Assert.assertNull((Object)logsResult4);
        FileIOUtils.LogData logsResult5 = loader.fetchLogs(1, "largeFiles", 0, 153600, 204800);
        Assert.assertNotNull((Object)logsResult5);
        Assert.assertEquals((String)("Logs length is " + logsResult5.getLength()), (long)logsResult5.getLength(), (long)181893L);
        FileIOUtils.LogData logsResult6 = loader.fetchLogs(1, "largeFiles", 0, 150000, 250000);
        Assert.assertNotNull((Object)logsResult6);
        Assert.assertEquals((String)("Logs length is " + logsResult6.getLength()), (long)logsResult6.getLength(), (long)185493L);
    }

    @Test
    public void testRemoveExecutionLogsByTime() throws ExecutorManagerException, IOException, InterruptedException {
        ExecutorLoader loader = this.createLoader();
        File logDir = new File("unit/executions/logtest");
        File[] largelog = new File[]{new File(logDir, "largeLog1.log"), new File(logDir, "largeLog2.log"), new File(logDir, "largeLog3.log")};
        DateTime time1 = DateTime.now();
        loader.uploadLogFile(1, "oldlog", 0, largelog);
        Thread.currentThread();
        Thread.sleep(5000L);
        loader.uploadLogFile(2, "newlog", 0, largelog);
        DateTime time2 = time1.plusMillis(2500);
        int count = loader.removeExecutionLogsByTime(time2.getMillis());
        System.out.print("Removed " + count + " records");
        FileIOUtils.LogData logs = loader.fetchLogs(1, "oldlog", 0, 0, 22222);
        Assert.assertTrue((logs == null ? 1 : 0) != 0);
        logs = loader.fetchLogs(2, "newlog", 0, 0, 22222);
        Assert.assertFalse((logs == null ? 1 : 0) != 0);
    }

    private ExecutableFlow createExecutableFlow(int executionId, String flowName) throws IOException {
        File jsonFlowFile = new File(this.flowDir, String.valueOf(flowName) + ".flow");
        HashMap flowObj = (HashMap)JSONUtils.parseJSONFromFile((File)jsonFlowFile);
        Flow flow = Flow.flowFromObject((Object)flowObj);
        Project project = new Project(1, "flow");
        HashMap<String, Flow> flowMap = new HashMap<String, Flow>();
        flowMap.put(flow.getId(), flow);
        project.setFlows(flowMap);
        ExecutableFlow execFlow = new ExecutableFlow(project, flow);
        execFlow.setExecutionId(executionId);
        return execFlow;
    }

    private ExecutableFlow createExecutableFlow(String flowName) throws IOException {
        File jsonFlowFile = new File(this.flowDir, String.valueOf(flowName) + ".flow");
        HashMap flowObj = (HashMap)JSONUtils.parseJSONFromFile((File)jsonFlowFile);
        Flow flow = Flow.flowFromObject((Object)flowObj);
        Project project = new Project(1, "flow");
        HashMap<String, Flow> flowMap = new HashMap<String, Flow>();
        flowMap.put(flow.getId(), flow);
        project.setFlows(flowMap);
        ExecutableFlow execFlow = new ExecutableFlow(project, flow);
        return execFlow;
    }

    private ExecutorLoader createLoader() {
        Props props = new Props();
        props.put("database.type", "mysql");
        props.put("mysql.host", "cyu-ld.linkedin.biz");
        props.put("mysql.port", Integer.valueOf(3306));
        props.put("mysql.user", "azkaban");
        props.put("mysql.database", "azkaban2");
        props.put("mysql.password", "azkaban");
        props.put("mysql.numconnections", Integer.valueOf(10));
        return new JdbcExecutorLoader(props);
    }

    private boolean isTestSetup() {
        if (!testDBExists) {
            System.err.println("Skipping DB test because Db not setup.");
            return false;
        }
        System.out.println("Running DB test because Db setup.");
        return true;
    }
}

