/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBSplitter;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.OracleDataDrivenDBRecordReader;
import org.apache.hadoop.mapreduce.lib.db.OracleDateSplitter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OracleDataDrivenDBInputFormat<T extends DBWritable>
extends DataDrivenDBInputFormat<T>
implements Configurable {
    @Override
    protected DBSplitter getSplitter(int sqlDataType) {
        switch (sqlDataType) {
            case 91: 
            case 92: 
            case 93: {
                return new OracleDateSplitter();
            }
        }
        return super.getSplitter(sqlDataType);
    }

    @Override
    protected RecordReader<LongWritable, T> createDBRecordReader(DBInputFormat.DBInputSplit split, Configuration conf) throws IOException {
        DBConfiguration dbConf = this.getDBConf();
        Class<?> inputClass = dbConf.getInputClass();
        try {
            return new OracleDataDrivenDBRecordReader(split, inputClass, conf, this.getConnection(), dbConf, dbConf.getInputConditions(), dbConf.getInputFieldNames(), dbConf.getInputTableName());
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

