/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp.event;

import azkaban.execapp.event.BlockingStatus;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.Status;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class FlowWatcher {
    private Logger logger;
    private int execId;
    private ExecutableFlow flow;
    private Map<String, BlockingStatus> map = new ConcurrentHashMap();
    private boolean cancelWatch = false;

    public FlowWatcher(int execId) {
        this.execId = execId;
    }

    public void setFlow(ExecutableFlow flow) {
        this.flow = flow;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected synchronized void handleJobStatusChange(String jobId, Status status) {
        BlockingStatus block = (BlockingStatus)this.map.get(jobId);
        if (block != null) {
            block.changeStatus(status);
        }
    }

    public int getExecId() {
        return this.execId;
    }

    public synchronized BlockingStatus getBlockingStatus(String jobId) {
        if (this.cancelWatch) {
            return null;
        }
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        if (node == null) {
            return null;
        }
        BlockingStatus blockingStatus = (BlockingStatus)this.map.get(jobId);
        if (blockingStatus == null) {
            blockingStatus = new BlockingStatus(this.execId, jobId, node.getStatus());
            this.map.put(jobId, blockingStatus);
        }
        return blockingStatus;
    }

    public Status peekStatus(String jobId) {
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        if (node != null) {
            return node.getStatus();
        }
        return null;
    }

    public synchronized void unblockAllWatches() {
        this.logger.info((Object)("Unblock all watches on " + this.execId));
        this.cancelWatch = true;
        for (BlockingStatus status : this.map.values()) {
            this.logger.info((Object)("Unblocking " + status.getJobId()));
            status.changeStatus(Status.SKIPPED);
            status.unblock();
        }
        this.logger.info((Object)("Successfully unblocked all watches on " + this.execId));
    }

    public boolean isWatchCancelled() {
        return this.cancelWatch;
    }

    public abstract void stopWatcher();
}

