/*
 * Decompiled with CFR 0.152.
 */
package azkaban.user;

import azkaban.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Permission {
    private Set<Type> permissions = new HashSet<Type>();

    public Permission() {
    }

    public Permission(int flags) {
        this.setPermissions(flags);
    }

    public Permission(Type ... list) {
        this.addPermission(list);
    }

    public void addPermissions(Permission perm) {
        this.permissions.addAll(perm.getTypes());
    }

    public void setPermission(Type type, boolean set) {
        if (set) {
            this.addPermission(type);
        } else {
            this.removePermissions(type);
        }
    }

    public void setPermissions(int flags) {
        this.permissions.clear();
        if ((flags & Type.ADMIN.getFlag()) != 0) {
            this.addPermission(Type.ADMIN);
        } else {
            for (Type type : Type.values()) {
                if ((flags & type.getFlag()) == 0) continue;
                this.addPermission(type);
            }
        }
    }

    public void addPermission(Type ... list) {
        if (!this.permissions.contains((Object)Type.ADMIN)) {
            for (Type perm : list) {
                this.permissions.add(perm);
            }
            if (this.permissions.contains((Object)Type.ADMIN)) {
                this.permissions.clear();
                this.permissions.add(Type.ADMIN);
            }
        }
    }

    public void addPermissionsByName(String ... list) {
        for (String perm : list) {
            Type type = Type.valueOf(perm);
            if (type == null) continue;
            this.addPermission(type);
        }
    }

    public void addPermissions(Collection<Type> list) {
        for (Type perm : list) {
            this.addPermission(perm);
        }
    }

    public void addPermissionsByName(Collection<String> list) {
        for (String perm : list) {
            Type type = Type.valueOf(perm);
            if (type == null) continue;
            this.addPermission(type);
        }
    }

    public Set<Type> getTypes() {
        return this.permissions;
    }

    public void removePermissions(Type ... list) {
        for (Type perm : list) {
            this.permissions.remove((Object)perm);
        }
    }

    public void removePermissionsByName(String ... list) {
        for (String perm : list) {
            Type type = Type.valueOf(perm);
            if (type == null) continue;
            this.permissions.remove((Object)type);
        }
    }

    public boolean isPermissionSet(Type permission) {
        return this.permissions.contains((Object)permission);
    }

    public boolean isPermissionNameSet(String permission) {
        return this.permissions.contains((Object)Type.valueOf(permission));
    }

    public String[] toStringArray() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        for (Type type : this.permissions) {
            list.add(type.toString());
            ++count;
        }
        return list.toArray(new String[count]);
    }

    public String toString() {
        return Utils.flattenToString(this.permissions, ",");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permissions == null ? 0 : ((Object)this.permissions).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permission other = (Permission)obj;
        return !(this.permissions == null ? other.permissions != null : !((Object)this.permissions).equals(other.permissions));
    }

    public int toFlags() {
        int flag = 0;
        for (Type type : this.permissions) {
            flag |= type.getFlag();
        }
        return flag;
    }

    public static enum Type {
        READ(1),
        WRITE(2),
        EXECUTE(4),
        SCHEDULE(8),
        CREATEPROJECTS(0x40000000),
        ADMIN(0x8000000);

        private int numVal;

        private Type(int numVal) {
            this.numVal = numVal;
        }

        public int getFlag() {
            return this.numVal;
        }
    }
}

