/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSkewedJoin
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private boolean[] mInnerFlags;
    private transient List<Schema> inputSchema = new ArrayList<Schema>();
    private MultiMap<PhysicalOperator, PhysicalPlan> mJoinPlans;

    public POSkewedJoin(OperatorKey k) {
        this(k, -1, null, null);
    }

    public POSkewedJoin(OperatorKey k, int rp) {
        this(k, rp, null, null);
    }

    public POSkewedJoin(OperatorKey k, List<PhysicalOperator> inp, boolean[] flags) {
        this(k, -1, inp, flags);
    }

    public POSkewedJoin(OperatorKey k, int rp, List<PhysicalOperator> inp, boolean[] flags) {
        super(k, rp, inp);
        if (flags != null) {
            this.mInnerFlags = new boolean[flags.length];
            for (int i = 0; i < flags.length; ++i) {
                this.mInnerFlags[i] = flags[i];
            }
        }
    }

    public boolean[] getInnerFlags() {
        return this.mInnerFlags;
    }

    public MultiMap<PhysicalOperator, PhysicalPlan> getJoinPlans() {
        return this.mJoinPlans;
    }

    public void setJoinPlans(MultiMap<PhysicalOperator, PhysicalPlan> joinPlans) {
        this.mJoinPlans = joinPlans;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitSkewedJoin(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "SkewedJoin[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public void addSchema(Schema s) {
        this.inputSchema.add(s);
    }

    public Schema getSchema(int i) {
        return this.inputSchema.get(i);
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }
}

