/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTupleDefaultRawComparator;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.BinSedesTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleRawComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class TupleFactory {
    private static TupleFactory gSelf = null;

    public static TupleFactory getInstance() {
        if (gSelf == null) {
            String factoryName = System.getProperty("pig.data.tuple.factory.name");
            String factoryJar = System.getProperty("pig.data.tuple.factory.jar");
            if (factoryName != null && factoryJar != null) {
                try {
                    URL[] urls = new URL[]{new URL(factoryJar)};
                    URLClassLoader loader = new URLClassLoader(urls, TupleFactory.class.getClassLoader());
                    Class<?> c = Class.forName(factoryName, true, loader);
                    Object o = c.newInstance();
                    if (!(o instanceof TupleFactory)) {
                        throw new RuntimeException("Provided factory " + factoryName + " does not extend TupleFactory!");
                    }
                    gSelf = (TupleFactory)o;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)e;
                        throw re;
                    }
                    throw new RuntimeException("Unable to instantiate tuple factory " + factoryName, e);
                }
            } else if (factoryName != null) {
                try {
                    Class<?> c = Class.forName(factoryName);
                    Object o = c.newInstance();
                    if (!(o instanceof TupleFactory)) {
                        throw new RuntimeException("Provided factory " + factoryName + " does not extend TupleFactory!");
                    }
                    gSelf = (TupleFactory)o;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)e;
                        throw re;
                    }
                    throw new RuntimeException("Unable to instantiate tuple factory " + factoryName, e);
                }
            } else {
                gSelf = new BinSedesTupleFactory();
            }
        }
        return gSelf;
    }

    public abstract Tuple newTuple();

    public abstract Tuple newTuple(int var1);

    public abstract Tuple newTuple(List var1);

    public abstract Tuple newTupleNoCopy(List var1);

    public abstract Tuple newTuple(Object var1);

    public abstract Class<? extends Tuple> tupleClass();

    protected TupleFactory() {
    }

    public static void resetSelf() {
        gSelf = null;
    }

    public Class<? extends TupleRawComparator> tupleRawComparatorClass() {
        return PigTupleDefaultRawComparator.class;
    }
}

