/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineageTracer {
    IdentityHashMap<Tuple, Tuple> parents = new IdentityHashMap();
    IdentityHashMap<Tuple, Integer> counts = new IdentityHashMap();
    IdentityHashMap<Tuple, Integer> ranks = new IdentityHashMap();

    public void insert(Tuple t) {
        if (this.parents.containsKey(t)) {
            this.counts.put(t, this.counts.get(t) + 1);
        } else {
            this.parents.put(t, t);
            this.counts.put(t, 1);
            this.ranks.put(t, 0);
        }
    }

    public void union(Tuple t1, Tuple t2) {
        this.link(this.getRepresentative(t1), this.getRepresentative(t2));
    }

    public Tuple getRepresentative(Tuple t) {
        Tuple tParent = this.parents.get(t);
        if (tParent != t) {
            tParent = this.getRepresentative(tParent);
            this.parents.put(t, tParent);
        }
        return tParent;
    }

    private void link(Tuple t1, Tuple t2) {
        int t2Rank;
        int t1Rank = this.ranks.get(t1);
        if (t1Rank > (t2Rank = this.ranks.get(t2).intValue())) {
            this.parents.put(t2, t1);
        } else {
            this.parents.put(t1, t2);
            if (t1Rank == t2Rank) {
                this.ranks.put(t2, t2Rank + 1);
            }
        }
    }

    public IdentityHashMap<Tuple, Integer> getCounts() {
        return this.getWeightedCounts(new IdentityHashSet<Tuple>(), 1);
    }

    public IdentityHashMap<Tuple, Integer> getWeightedCounts(IdentityHashSet<Tuple> specialTuples, int multiplier) {
        IdentityHashMap<Tuple, Integer> repCounts = new IdentityHashMap<Tuple, Integer>();
        IdentityHashSet<Tuple> specialSets = new IdentityHashSet<Tuple>();
        for (Map.Entry<Tuple, Integer> entry : this.counts.entrySet()) {
            Tuple t = entry.getKey();
            int newCount = this.counts.get(t);
            Tuple rep = this.getRepresentative(t);
            int oldCount = repCounts.containsKey(rep) ? repCounts.get(rep) : 0;
            repCounts.put(rep, oldCount + newCount);
            if (!specialTuples.contains(t)) continue;
            specialSets.add(rep);
        }
        for (Map.Entry<Tuple, Integer> entry : repCounts.entrySet()) {
            if (!specialSets.contains(entry.getKey())) continue;
            entry.setValue(entry.getValue() * multiplier);
        }
        return repCounts;
    }

    public Collection<Tuple> getMembers(Tuple t) {
        Tuple representative = this.getRepresentative(t);
        LinkedList<Tuple> members = new LinkedList<Tuple>();
        for (Map.Entry<Tuple, Integer> e : this.counts.entrySet()) {
            Tuple t1 = e.getKey();
            if (this.getRepresentative(t1) != representative) continue;
            members.add(t1);
        }
        return members;
    }

    public IdentityHashMap<Tuple, Collection<Tuple>> getMembershipMap() {
        IdentityHashMap<Tuple, Collection<Tuple>> map = new IdentityHashMap<Tuple, Collection<Tuple>>();
        for (Map.Entry<Tuple, Integer> e : this.counts.entrySet()) {
            Tuple t = e.getKey();
            Tuple representative = this.getRepresentative(t);
            Collection<Tuple> members = map.get(representative);
            if (members == null) {
                members = new LinkedList<Tuple>();
                map.put(representative, members);
            }
            members.add(t);
        }
        return map;
    }
}

