/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.ColumnExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.SourceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DereferenceExpression
extends ColumnExpression {
    private List<Object> rawColumns = new ArrayList<Object>();
    private List<Integer> columns = new ArrayList<Integer>();

    public DereferenceExpression(OperatorPlan plan) {
        super("Dereference", plan);
        plan.add(this);
    }

    public DereferenceExpression(OperatorPlan plan, int colNum) {
        this(plan);
        this.columns.add(colNum);
    }

    public DereferenceExpression(OperatorPlan plan, List<Integer> columnNums) {
        this(plan);
        this.columns.addAll(columnNums);
    }

    public void setRawColumns(List<Object> cols) {
        this.rawColumns.addAll(cols);
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public List<Integer> getBagColumns() {
        return this.columns;
    }

    public void setBagColumns(List<Integer> columns) {
        this.columns = columns;
        this.rawColumns.clear();
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof DereferenceExpression) {
            DereferenceExpression po = (DereferenceExpression)other;
            if (po.columns.size() != this.columns.size()) {
                return false;
            }
            return po.columns.containsAll(this.columns) && this.getReferredExpression().isEqual(po.getReferredExpression());
        }
        return false;
    }

    public LogicalExpression getReferredExpression() throws FrontendException {
        if (this.plan.getSuccessors(this).size() < 1) {
            throw new FrontendException("Could not find a related project Expression for Dereference", 2228);
        }
        return (LogicalExpression)this.plan.getSuccessors(this).get(0);
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("(Name: " + this.name + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(" Column:" + this.columns);
        msg.append(")");
        return msg.toString();
    }

    @Override
    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        LogicalExpression successor = (LogicalExpression)this.plan.getSuccessors(this).get(0);
        LogicalSchema.LogicalFieldSchema predFS = successor.getFieldSchema();
        if (predFS != null) {
            if (predFS.type == 120) {
                LogicalSchema innerSchema = null;
                if (predFS.schema != null) {
                    innerSchema = new LogicalSchema();
                    LogicalSchema origSchema = predFS.schema.getField((int)0).schema;
                    if (!this.rawColumns.isEmpty()) {
                        this.columns = this.translateAliasToPos(origSchema, this.rawColumns);
                    }
                    for (int column : this.columns) {
                        if (origSchema != null && origSchema.size() != 0) {
                            innerSchema.addField(origSchema.getField(column));
                            continue;
                        }
                        innerSchema.addField(new LogicalSchema.LogicalFieldSchema(null, null, 50));
                    }
                }
                LogicalSchema bagSchema = new LogicalSchema();
                bagSchema.addField(new LogicalSchema.LogicalFieldSchema(null, innerSchema, 110, LogicalExpression.getNextUid()));
                this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, bagSchema, 120, LogicalExpression.getNextUid());
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            } else if (predFS.schema != null) {
                if (!this.rawColumns.isEmpty()) {
                    this.columns = this.translateAliasToPos(predFS.schema, this.rawColumns);
                }
                if (predFS.schema != null && predFS.schema.size() != 0) {
                    this.fieldSchema = predFS.schema.getField(this.columns.get(0));
                } else {
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, 50);
                    this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
                }
            } else {
                this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, 50);
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            }
        }
        return this.fieldSchema;
    }

    private List<Integer> translateAliasToPos(LogicalSchema schema, List<Object> rawColumns) throws FrontendException {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        for (Object rawColumn : rawColumns) {
            if (rawColumn instanceof Integer) {
                if (schema != null && ((Integer)rawColumn >= schema.size() || (Integer)rawColumn < 0)) {
                    throw new FrontendException("Index " + rawColumn + " out of range in schema:" + schema.toString(false), 1127);
                }
                columns.add((Integer)rawColumn);
                continue;
            }
            int pos = schema.getFieldPosition((String)rawColumn);
            if (pos != -1) {
                columns.add(pos);
                continue;
            }
            throw new FrontendException("Cannot find field " + rawColumn + " in " + schema.toString(false), 1128);
        }
        return columns;
    }

    @Override
    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        ArrayList<Integer> columnsCopy = new ArrayList<Integer>(this.getBagColumns());
        DereferenceExpression copy = new DereferenceExpression((OperatorPlan)lgExpPlan, columnsCopy);
        ArrayList<Object> rawColumnsCopy = new ArrayList<Object>(this.rawColumns);
        copy.setRawColumns(rawColumnsCopy);
        LogicalExpression input = (LogicalExpression)this.plan.getSuccessors(this).get(0);
        LogicalExpression inputCopy = input.deepCopy(lgExpPlan);
        lgExpPlan.add(inputCopy);
        lgExpPlan.connect(copy, inputCopy);
        copy.setLocation(new SourceLocation(this.location));
        return copy;
    }

    public List<Object> getRawColumns() {
        return this.rawColumns;
    }
}

