/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.ConditionChecker;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerException;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;

public class TriggerManagerRemoteAdapter
implements TriggerManagerAdapter {
    private final String host;
    private final int port;

    public TriggerManagerRemoteAdapter(Props props) {
        this.host = props.getString("trigger.server.host", "localhost");
        this.port = props.getInt("trigger.server.port");
    }

    @Override
    public void insertTrigger(Trigger t, String user) throws TriggerManagerException {
        try {
            this.callRemoteTriggerRunnerManager("insert", t.getTriggerId(), user, null);
        }
        catch (IOException e) {
            throw new TriggerManagerException(e);
        }
    }

    @Override
    public void removeTrigger(int id, String user) throws TriggerManagerException {
        try {
            this.callRemoteTriggerRunnerManager("remove", id, user, null);
        }
        catch (IOException e) {
            throw new TriggerManagerException(e);
        }
    }

    @Override
    public void updateTrigger(int triggerId, String user) throws TriggerManagerException {
        try {
            this.callRemoteTriggerRunnerManager("update", triggerId, user, null);
        }
        catch (IOException e) {
            throw new TriggerManagerException(e);
        }
    }

    private Map<String, Object> callRemoteTriggerRunnerManager(String action, Integer triggerId, String user, Pair<String, String> ... params) throws IOException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http").setHost(this.host).setPort(this.port).setPath("/triggermanager");
        builder.setParameter("action", action);
        if (triggerId != null) {
            builder.setParameter("triggerid", String.valueOf(triggerId));
        }
        if (user != null) {
            builder.setParameter("user", user);
        }
        if (params != null) {
            for (Pair<String, String> pair : params) {
                builder.setParameter(pair.getFirst(), pair.getSecond());
            }
        }
        URI uri = null;
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(uri);
        String response = null;
        try {
            response = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString(response);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    @Override
    public void start() {
    }

    @Override
    public void insertTrigger(int triggerId, String user) throws TriggerManagerException {
        try {
            this.callRemoteTriggerRunnerManager("insert", triggerId, user, null);
        }
        catch (IOException e) {
            throw new TriggerManagerException(e);
        }
    }

    @Override
    public List<Integer> getTriggerUpdates(long lastUpdateTime) throws TriggerManagerException {
        try {
            Map<String, Object> response = this.callRemoteTriggerRunnerManager("getupdate", null, "azkaban", null);
            List updated = (List)response.get("updated");
            return updated;
        }
        catch (IOException e) {
            throw new TriggerManagerException(e);
        }
    }

    @Override
    public void updateTrigger(Trigger t, String user) throws TriggerManagerException {
    }

    @Override
    public List<Trigger> getTriggerUpdates(String triggerSource, long lastUpdateTime) throws TriggerManagerException {
        return null;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void registerCheckerType(String name, Class<? extends ConditionChecker> checker) {
    }

    @Override
    public void registerActionType(String name, Class<? extends TriggerAction> action) {
    }

    @Override
    public TriggerManagerAdapter.TriggerJMX getJMX() {
        return null;
    }
}

