/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.sla.SlaOption;
import azkaban.trigger.ConditionChecker;
import azkaban.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;

public class SlaChecker
implements ConditionChecker {
    private static final Logger logger = Logger.getLogger(SlaChecker.class);
    public static final String type = "SlaChecker";
    private String id;
    private SlaOption slaOption;
    private int execId;
    private Map<String, Object> context;
    private boolean passChecker = true;
    private static ExecutorManagerAdapter executorManager;

    public SlaChecker(String id, SlaOption slaOption, int execId, boolean passChecker) {
        this.id = id;
        this.slaOption = slaOption;
        this.execId = execId;
        this.passChecker = passChecker;
    }

    public SlaChecker(String id, SlaOption sla, String executionActionId, boolean passChecker) {
        Map executeActionProps = (Map)this.context.get(executionActionId);
        int execId = Integer.valueOf((String)executeActionProps.get("ExecuteFlowAction.execid"));
        this.id = id;
        this.slaOption = sla;
        this.execId = execId;
        this.passChecker = passChecker;
    }

    public static void setExecutorManager(ExecutorManagerAdapter em) {
        executorManager = em;
    }

    private Boolean metSla(ExecutableFlow flow) {
        String jobName;
        ExecutableNode node;
        String type = this.slaOption.getType();
        logger.info((Object)("Checking for " + flow.getExecutionId() + " with sla " + type));
        logger.info((Object)("flow is " + (Object)((Object)flow.getStatus())));
        if (flow.getStartTime() < 0L) {
            return null;
        }
        if (type.equals("FlowFinish")) {
            ReadablePeriod duration = Utils.parsePeriodString((String)this.slaOption.getInfo().get("Duration"));
            DateTime startTime = new DateTime(flow.getStartTime());
            DateTime checkTime = startTime.plus(duration);
            if (checkTime.isBeforeNow()) {
                Status status = flow.getStatus();
                if (status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED) || status.equals((Object)Status.SUCCEEDED)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        } else if (type.equals("FlowSucceed")) {
            ReadablePeriod duration = Utils.parsePeriodString((String)this.slaOption.getInfo().get("Duration"));
            DateTime startTime = new DateTime(flow.getStartTime());
            DateTime checkTime = startTime.plus(duration);
            if (checkTime.isBeforeNow()) {
                Status status = flow.getStatus();
                if (status.equals((Object)Status.SUCCEEDED)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        } else if (type.equals("JobFinish")) {
            String jobName2 = (String)this.slaOption.getInfo().get("JobName");
            ExecutableNode node2 = flow.getExecutableNode(jobName2);
            if (node2.getStartTime() > 0L) {
                ReadablePeriod duration = Utils.parsePeriodString((String)this.slaOption.getInfo().get("Duration"));
                DateTime startTime = new DateTime(node2.getStartTime());
                DateTime checkTime = startTime.plus(duration);
                if (checkTime.isBeforeNow()) {
                    Status status = node2.getStatus();
                    if (status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED) || status.equals((Object)Status.SUCCEEDED)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            }
        } else if (type.equals("JobSucceed") && (node = flow.getExecutableNode(jobName = (String)this.slaOption.getInfo().get("JobName"))).getStartTime() > 0L) {
            ReadablePeriod duration = Utils.parsePeriodString((String)this.slaOption.getInfo().get("Duration"));
            DateTime startTime = new DateTime(node.getStartTime());
            DateTime checkTime = startTime.plus(duration);
            if (checkTime.isBeforeNow()) {
                Status status = node.getStatus();
                if (status.equals((Object)Status.SUCCEEDED)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public Object eval() {
        ExecutableFlow flow;
        try {
            flow = executorManager.getExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Can't get executable flow.", (Throwable)e);
            e.printStackTrace();
            return Boolean.TRUE;
        }
        Boolean metSla = this.metSla(flow);
        if (metSla == null) {
            return Boolean.FALSE;
        }
        if (this.passChecker) {
            return metSla;
        }
        return metSla == false;
    }

    @Override
    public Object getNum() {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public ConditionChecker fromJson(Object obj) throws Exception {
        return SlaChecker.createFromJson(obj);
    }

    public static SlaChecker createFromJson(Object obj) throws Exception {
        return SlaChecker.createFromJson((HashMap)obj);
    }

    public static SlaChecker createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create checker of SlaChecker from " + jsonObj.get("type"));
        }
        String id = (String)jsonObj.get("id");
        SlaOption slaOption = SlaOption.fromObject(jsonObj.get("slaOption"));
        int execId = Integer.valueOf((String)jsonObj.get("execId"));
        boolean passChecker = (Boolean)jsonObj.get("passChecker");
        return new SlaChecker(id, slaOption, execId, passChecker);
    }

    @Override
    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("type", type);
        jsonObj.put("id", this.id);
        jsonObj.put("slaOption", this.slaOption.toObject());
        jsonObj.put("execId", String.valueOf(this.execId));
        jsonObj.put("passChecker", this.passChecker);
        return jsonObj;
    }

    @Override
    public void stopChecker() {
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public long getNextCheckTime() {
        return 0L;
    }
}

