/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import voldemort.serialization.Serializer;
import voldemort.utils.ByteUtils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedSerializer<T>
implements Serializer<Versioned<T>> {
    private final Serializer<T> innerSerializer;

    public VersionedSerializer(Serializer<T> innerSerializer) {
        this.innerSerializer = innerSerializer;
    }

    @Override
    public byte[] toBytes(Versioned<T> versioned) {
        byte[] versionBytes = null;
        versionBytes = versioned.getVersion() == null ? new byte[]{-1} : ((VectorClock)versioned.getVersion()).toBytes();
        byte[] objectBytes = this.innerSerializer.toBytes(versioned.getValue());
        return ByteUtils.cat(versionBytes, objectBytes);
    }

    @Override
    public Versioned<T> toObject(byte[] bytes) {
        VectorClock vectorClock = this.getVectorClock(bytes);
        int size = 1;
        if (vectorClock != null) {
            size = vectorClock.sizeInBytes();
        }
        T t = this.innerSerializer.toObject(ByteUtils.copy(bytes, size, bytes.length));
        return new Versioned<T>(t, vectorClock);
    }

    public Version getVersion(byte[] bytes) {
        return this.getVectorClock(bytes);
    }

    private VectorClock getVectorClock(byte[] bytes) {
        if (bytes[0] >= 0) {
            return new VectorClock(bytes);
        }
        return null;
    }
}

