/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http;

import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.client.protocol.RequestFormatType;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortServer;
import voldemort.server.http.StoreServlet;
import voldemort.server.http.gui.AdminServlet;
import voldemort.server.http.gui.ReadOnlyStoreManagementServlet;
import voldemort.server.http.gui.StatusServlet;
import voldemort.server.http.gui.VelocityEngine;
import voldemort.server.protocol.RequestHandler;
import voldemort.server.protocol.SocketRequestHandlerFactory;
import voldemort.server.storage.StorageService;

@JmxManaged(description="A store connector that serves remote clients via HTTP.")
public class HttpService
extends AbstractService {
    private final Logger logger = Logger.getLogger(HttpService.class);
    private final int port;
    private final int numberOfThreads;
    private final VoldemortServer server;
    private final VelocityEngine velocityEngine;
    private final RequestHandler requestHandler;
    private Server httpServer;
    private Context context;

    public HttpService(VoldemortServer server, StorageService storageService, StoreRepository storeRepository, RequestFormatType requestType, int numberOfThreads, int httpPort) {
        super(ServiceType.HTTP);
        this.port = httpPort;
        this.numberOfThreads = numberOfThreads;
        this.server = server;
        this.velocityEngine = new VelocityEngine("voldemort/server/http/gui/templates");
        this.requestHandler = new SocketRequestHandlerFactory(storageService, server.getStoreRepository(), server.getMetadataStore(), server.getVoldemortConfig(), server.getAsyncRunner(), null).getRequestHandler(requestType);
    }

    public void startInner() {
        try {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setLowResourceMaxIdleTime(3000);
            connector.setPort(this.port);
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName("VoldemortHttp");
            threadPool.setMaxThreads(this.numberOfThreads);
            Server httpServer = new Server();
            httpServer.setConnectors(new Connector[]{connector});
            httpServer.setThreadPool((ThreadPool)threadPool);
            httpServer.setSendServerVersion(false);
            httpServer.setSendDateHeader(false);
            Context context = new Context((HandlerContainer)httpServer, "/", 0);
            context.setAttribute("vldmt_server", (Object)this.server);
            context.setAttribute("vldmt_velocity_engine", (Object)this.velocityEngine);
            context.addServlet(new ServletHolder((Servlet)new AdminServlet(this.server, this.velocityEngine)), "/admin");
            context.addServlet(new ServletHolder((Servlet)new StoreServlet(this.requestHandler)), "/stores");
            context.addServlet(new ServletHolder((Servlet)new ReadOnlyStoreManagementServlet(this.server, this.velocityEngine)), "/read-only/mgmt");
            context.addServlet(new ServletHolder((Servlet)new StatusServlet(this.server, this.velocityEngine)), "/server-status");
            this.context = context;
            this.httpServer = httpServer;
            this.httpServer.start();
            this.logger.info((Object)("HTTP service started on port " + this.port));
        }
        catch (Exception e) {
            throw new VoldemortException(e);
        }
    }

    public void stopInner() {
        try {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            if (this.context != null) {
                this.context.destroy();
            }
        }
        catch (Exception e) {
            throw new VoldemortException(e);
        }
        this.httpServer = null;
        this.context = null;
    }

    @JmxGetter(name="numberOfThreads", description="The number of threads used for the thread pool for HTTP.")
    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    @JmxGetter(name="port", description="The port on which http connections are accepted.")
    public int getPort() {
        return this.port;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }
}

