/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import com.google.common.collect.AbstractIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.serialization.Serializer;
import voldemort.utils.ByteUtils;
import voldemort.utils.DefaultIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalSorter<V> {
    public static final Logger logger = Logger.getLogger(ExternalSorter.class);
    private final Serializer<V> serializer;
    private final Comparator<V> comparator;
    private final boolean gzip;
    private final int internalSortSize;
    private final File tempDir;
    private final int bufferSize;
    private final int numThreads;

    public ExternalSorter(Serializer<V> serializer, int internalSortSize, int numThreads) {
        this(serializer, new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        }, internalSortSize, System.getProperty("java.io.tmpdir"), 0xA00000, numThreads, false);
    }

    public ExternalSorter(Serializer<V> serializer, Comparator<V> comparator, int internalSortSize, int numThreads) {
        this(serializer, comparator, internalSortSize, System.getProperty("java.io.tmpdir"), 0xA00000, numThreads, false);
    }

    public ExternalSorter(Serializer<V> serializer, Comparator<V> comparator, int internalSortSize, String tempDir, int bufferSize, int numThreads, boolean gzip) {
        this.serializer = serializer;
        this.comparator = comparator;
        this.internalSortSize = internalSortSize;
        this.tempDir = new File(tempDir);
        this.bufferSize = bufferSize;
        this.numThreads = numThreads;
        this.gzip = gzip;
    }

    public Iterable<V> sorted(Iterator<V> input) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 1000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        AtomicInteger count = new AtomicInteger(0);
        final List<File> tempFiles = Collections.synchronizedList(new ArrayList());
        while (input.hasNext()) {
            int segmentSizeIter;
            final int segmentId = count.getAndIncrement();
            final long segmentStartMs = System.currentTimeMillis();
            logger.info((Object)("Segment " + segmentId + ": filling sort buffer for segment..."));
            final Object[] buffer = new Object[this.internalSortSize];
            for (segmentSizeIter = 0; segmentSizeIter < this.internalSortSize && input.hasNext(); ++segmentSizeIter) {
                buffer[segmentSizeIter] = input.next();
            }
            final int segmentSize = segmentSizeIter;
            logger.info((Object)("Segment " + segmentId + ": sort buffer filled...adding to sort queue."));
            executor.execute(new Runnable(){

                public void run() {
                    logger.info((Object)("Segment " + segmentId + ": sorting buffer."));
                    long start = System.currentTimeMillis();
                    Arrays.sort(buffer, 0, segmentSize, ExternalSorter.this.comparator);
                    long ellapsed = System.currentTimeMillis() - start;
                    logger.info((Object)("Segment " + segmentId + ": sort completed in " + ellapsed + " ms, writing to temp file."));
                    try {
                        File tempFile = File.createTempFile("segment-", ".dat", ExternalSorter.this.tempDir);
                        tempFile.deleteOnExit();
                        tempFiles.add(tempFile);
                        FilterOutputStream os = new BufferedOutputStream(new FileOutputStream(tempFile), ExternalSorter.this.bufferSize);
                        if (ExternalSorter.this.gzip) {
                            os = new GZIPOutputStream(os);
                        }
                        DataOutputStream output = new DataOutputStream(os);
                        for (int i = 0; i < segmentSize; ++i) {
                            ExternalSorter.this.writeValue(output, buffer[i]);
                        }
                        output.close();
                    }
                    catch (IOException e) {
                        throw new VoldemortException(e);
                    }
                    long segmentEllapsed = System.currentTimeMillis() - segmentStartMs;
                    logger.info((Object)("Segment " + segmentId + ": completed processing of segment in " + segmentEllapsed + " ms."));
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            return new DefaultIterable(new ExternalSorterIterator(tempFiles, this.bufferSize / tempFiles.size()));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeValue(DataOutputStream stream, V value) {
        byte[] bytes = this.serializer.toBytes(value);
        try {
            stream.writeInt(bytes.length);
            stream.write(bytes);
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    private V readValue(DataInputStream stream) throws EOFException {
        try {
            int size = stream.readInt();
            byte[] bytes = new byte[size];
            ByteUtils.read(stream, bytes);
            return this.serializer.toObject(bytes);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    private static class FileAndStream {
        private final DataInputStream inputStream;
        private final File file;

        private FileAndStream(File file, DataInputStream inputStream) {
            this.inputStream = inputStream;
            this.file = file;
        }

        public DataInputStream getInputStream() {
            return this.inputStream;
        }

        public File getFile() {
            return this.file;
        }

        public void closeAndDelete() {
            try {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw new VoldemortException("Failed to close input stream.", e);
                }
                Object var3_1 = null;
                this.file.delete();
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.file.delete();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Item
    implements Comparable<Item> {
        private final int index;
        private final V v;

        public Item(int index, V value) {
            this.index = index;
            this.v = value;
        }

        public int getIndex() {
            return this.index;
        }

        public V getValue() {
            return this.v;
        }

        @Override
        public int compareTo(Item item) {
            return ExternalSorter.this.comparator.compare(this.v, item.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExternalSorterIterator
    extends AbstractIterator<V>
    implements Iterator<V> {
        private final List<FileAndStream> inputs;
        private final PriorityQueue<Item> minHeap;

        public ExternalSorterIterator(List<File> files, int readBufferSize) {
            this.inputs = new ArrayList<FileAndStream>(files.size());
            for (File f : files) {
                try {
                    FilterInputStream is = new BufferedInputStream(new FileInputStream(f), readBufferSize);
                    if (ExternalSorter.this.gzip) {
                        is = new GZIPInputStream(is);
                    }
                    DataInputStream inputStream = new DataInputStream(is);
                    this.inputs.add(new FileAndStream(f, inputStream));
                }
                catch (IOException e) {
                    throw new VoldemortException(e);
                }
            }
            this.minHeap = new PriorityQueue(this.inputs.size());
            for (int i = 0; i < this.inputs.size(); ++i) {
                FileAndStream fas = this.inputs.get(i);
                try {
                    Object v = ExternalSorter.this.readValue(fas.getInputStream());
                    this.minHeap.add(new Item(i, v));
                    continue;
                }
                catch (EOFException e) {
                    fas.closeAndDelete();
                }
            }
        }

        protected V computeNext() {
            if (this.minHeap.peek() == null) {
                return this.endOfData();
            }
            Item curr = this.minHeap.poll();
            FileAndStream fas = this.inputs.get(curr.getIndex());
            try {
                Object v = ExternalSorter.this.readValue(fas.getInputStream());
                if (v != null) {
                    this.minHeap.add(new Item(curr.getIndex(), v));
                }
            }
            catch (EOFException e) {
                fas.closeAndDelete();
            }
            return curr.getValue();
        }
    }
}

