/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortApplicationException;
import voldemort.cluster.Node;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.routed.NodeValue;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PipelineData;
import voldemort.store.routed.ReadRepairer;
import voldemort.store.routed.action.AbstractAction;
import voldemort.utils.ByteArray;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadRepair<K, V, PD extends PipelineData<K, V>>
extends AbstractAction<K, V, PD> {
    private final int preferred;
    private final long timeoutMs;
    private final Map<Integer, NonblockingStore> nonblockingStores;
    private final ReadRepairer<ByteArray, byte[]> readRepairer;
    private final List<NodeValue<ByteArray, byte[]>> nodeValues;

    public AbstractReadRepair(PD pipelineData, Pipeline.Event completeEvent, int preferred, long timeoutMs, Map<Integer, NonblockingStore> nonblockingStores, ReadRepairer<ByteArray, byte[]> readRepairer) {
        super(pipelineData, completeEvent);
        this.preferred = preferred;
        this.timeoutMs = timeoutMs;
        this.nonblockingStores = nonblockingStores;
        this.readRepairer = readRepairer;
        this.nodeValues = Lists.newArrayListWithExpectedSize((int)((PipelineData)pipelineData).getResponses().size());
    }

    protected abstract void insertNodeValues();

    protected void insertNodeValue(Node node, ByteArray key, List<Versioned<byte[]>> value) {
        if (value.size() == 0) {
            Versioned<Object> versioned = new Versioned<Object>(null);
            this.nodeValues.add(new NodeValue<ByteArray, Object>(node.getId(), key, versioned));
        } else {
            for (Versioned<byte[]> versioned : value) {
                this.nodeValues.add(new NodeValue<ByteArray, byte[]>(node.getId(), key, versioned));
            }
        }
    }

    @Override
    public void execute(Pipeline pipeline) {
        this.insertNodeValues();
        long startTimeNs = -1L;
        if (this.logger.isTraceEnabled()) {
            startTimeNs = System.nanoTime();
        }
        if (this.nodeValues.size() > 1 && this.preferred > 1) {
            ArrayList toReadRepair = Lists.newArrayList();
            for (NodeValue<ByteArray, byte[]> nodeValue : this.readRepairer.getRepairs(this.nodeValues)) {
                Versioned<byte[]> versioned = Versioned.value(nodeValue.getVersioned().getValue(), ((VectorClock)nodeValue.getVersion()).clone());
                toReadRepair.add(new NodeValue<ByteArray, byte[]>(nodeValue.getNodeId(), nodeValue.getKey(), versioned));
            }
            for (NodeValue<ByteArray, Object> nodeValue : toReadRepair) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Doing read repair on node " + nodeValue.getNodeId() + " for key '" + nodeValue.getKey() + "' with version " + nodeValue.getVersion() + "."));
                    }
                    NonblockingStore store = this.nonblockingStores.get(nodeValue.getNodeId());
                    store.submitPutRequest(nodeValue.getKey(), nodeValue.getVersioned(), null, null, this.timeoutMs);
                }
                catch (VoldemortApplicationException e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Read repair cancelled due to application level exception on node " + nodeValue.getNodeId() + " for key '" + nodeValue.getKey() + "' with version " + nodeValue.getVersion() + ": " + e.getMessage()));
                }
                catch (Exception e) {
                    this.logger.debug((Object)"Read repair failed: ", (Throwable)e);
                }
            }
            if (this.logger.isDebugEnabled()) {
                String logStr = "Repaired (node, key, version): (";
                for (NodeValue v : toReadRepair) {
                    logStr = logStr + "(" + v.getNodeId() + ", " + v.getKey() + "," + v.getVersion() + ") ";
                }
                logStr = logStr + "in " + (System.nanoTime() - startTimeNs) + " ns";
                this.logger.debug((Object)logStr);
            }
        }
        pipeline.addEvent(this.completeEvent);
    }
}

