/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import org.apache.pig.FuncSpec;
import org.apache.pig.SortInfo;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOStore
extends LogicalRelationalOperator {
    private static final long serialVersionUID = 2L;
    private FileSpec output;
    private FileSpec mInputSpec;
    private String signature;
    private boolean isTmpStore;
    private SortInfo sortInfo;
    private transient StoreFuncInterface storeFunc;

    public LOStore(LogicalPlan plan) {
        super("LOStore", plan);
    }

    public LOStore(LogicalPlan plan, FileSpec outputFileSpec) {
        super("LOStore", plan);
        this.output = outputFileSpec;
        this.storeFunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(outputFileSpec.getFuncSpec());
    }

    public FileSpec getOutputSpec() {
        return this.output;
    }

    public StoreFuncInterface getStoreFunc() {
        return this.storeFunc;
    }

    public LogicalSchema getSchema() throws FrontendException {
        this.schema = ((LogicalRelationalOperator)this.plan.getPredecessors(this).get(0)).getSchema();
        return this.schema;
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOStore) {
            LOStore os = (LOStore)other;
            if (!this.checkEquality(os)) {
                return false;
            }
            if (this.output == null && os.output == null) {
                return true;
            }
            if (this.output == null || os.output == null) {
                return false;
            }
            return this.output.equals(os.output);
        }
        return false;
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public boolean isTmpStore() {
        return this.isTmpStore;
    }

    public void setTmpStore(boolean isTmpStore) {
        this.isTmpStore = isTmpStore;
    }

    public void setInputSpec(FileSpec in) {
        this.mInputSpec = in;
    }

    public FileSpec getInputSpec() {
        return this.mInputSpec;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String sig) {
        this.signature = sig;
        this.storeFunc.setStoreFuncUDFContextSignature(this.signature);
    }

    public static String constructSignature(String alias, String filename, FuncSpec funcSpec) {
        return alias + "_" + filename + "_" + funcSpec.toString();
    }

    public FileSpec getFileSpec() {
        return this.output;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.setSignature(LOStore.constructSignature(alias, this.output.getFileName(), this.output.getFuncSpec()));
    }
}

