/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster.failuredetector;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.FailureDetectorListener;
import voldemort.cluster.failuredetector.NodeStatus;
import voldemort.store.UnreachableStoreException;

public abstract class AbstractFailureDetector
implements FailureDetector {
    protected final FailureDetectorConfig failureDetectorConfig;
    protected final ConcurrentHashMap<FailureDetectorListener, Object> listeners;
    protected final Map<Integer, CompositeNodeStatus> idNodeStatusMap;
    protected final Logger logger = Logger.getLogger((String)this.getClass().getName());

    protected AbstractFailureDetector(FailureDetectorConfig failureDetectorConfig) {
        if (failureDetectorConfig == null) {
            throw new IllegalArgumentException("FailureDetectorConfig must be non-null");
        }
        this.failureDetectorConfig = failureDetectorConfig;
        this.listeners = new ConcurrentHashMap();
        this.idNodeStatusMap = new ConcurrentHashMap<Integer, CompositeNodeStatus>();
        for (Node node : failureDetectorConfig.getNodes()) {
            this.idNodeStatusMap.put(node.getId(), new CompositeNodeStatus(node, this.createNodeStatus(failureDetectorConfig.getTime().getMilliseconds())));
        }
    }

    private NodeStatus createNodeStatus(long currTime) {
        NodeStatus nodeStatus = new NodeStatus();
        nodeStatus.setLastChecked(currTime);
        nodeStatus.setStartMillis(currTime);
        nodeStatus.setAvailable(true);
        return nodeStatus;
    }

    public void addFailureDetectorListener(FailureDetectorListener failureDetectorListener) {
        if (failureDetectorListener == null) {
            throw new IllegalArgumentException("FailureDetectorListener must be non-null");
        }
        this.listeners.put(failureDetectorListener, failureDetectorListener);
    }

    public void removeFailureDetectorListener(FailureDetectorListener failureDetectorListener) {
        if (failureDetectorListener == null) {
            throw new IllegalArgumentException("FailureDetectorListener must be non-null");
        }
        this.listeners.remove(failureDetectorListener);
    }

    public FailureDetectorConfig getConfig() {
        return this.failureDetectorConfig;
    }

    @JmxGetter(name="availableNodes", description="The available nodes")
    public String getAvailableNodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Node node : this.getConfig().getNodes()) {
            if (!this.isAvailable(node)) continue;
            list.add(String.valueOf(node.getId()));
        }
        return StringUtils.join(list, (String)",");
    }

    @JmxGetter(name="unavailableNodes", description="The unavailable nodes")
    public String getUnavailableNodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Node node : this.getConfig().getNodes()) {
            if (this.isAvailable(node)) continue;
            list.add(String.valueOf(node.getId()));
        }
        return StringUtils.join(list, (String)",");
    }

    @JmxGetter(name="availableNodeCount", description="The number of available nodes")
    public int getAvailableNodeCount() {
        int available = 0;
        for (Node node : this.getConfig().getNodes()) {
            if (!this.isAvailable(node)) continue;
            ++available;
        }
        return available;
    }

    @JmxGetter(name="nodeCount", description="The number of total nodes")
    public int getNodeCount() {
        return this.getConfig().getNodes().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAvailability(Node node) throws InterruptedException {
        NodeStatus nodeStatus;
        this.checkNodeArg(node);
        NodeStatus nodeStatus2 = nodeStatus = this.getNodeStatus(node);
        synchronized (nodeStatus2) {
            while (!this.isAvailable(node)) {
                nodeStatus.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastChecked(Node node) {
        NodeStatus nodeStatus;
        this.checkNodeArg(node);
        NodeStatus nodeStatus2 = nodeStatus = this.getNodeStatus(node);
        synchronized (nodeStatus2) {
            return nodeStatus.getLastChecked();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAvailable(Node node) {
        boolean previouslyAvailable;
        NodeStatus nodeStatus = this.getNodeStatus(node);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Node " + node.getId() + " set as available"));
        }
        if (!(previouslyAvailable = this.setAvailable(nodeStatus, true))) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Node " + node.getId() + " now available"));
            }
            NodeStatus nodeStatus2 = nodeStatus;
            synchronized (nodeStatus2) {
                nodeStatus.notifyAll();
            }
            for (FailureDetectorListener fdl : this.listeners.keySet()) {
                try {
                    fdl.nodeAvailable(node);
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) continue;
                    this.logger.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void setUnavailable(Node node, UnreachableStoreException e) {
        boolean previouslyAvailable;
        NodeStatus nodeStatus = this.getNodeStatus(node);
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            if (e != null) {
                this.logger.warn((Object)("Node " + node.getId() + " set as unavailable"), (Throwable)e);
            } else {
                this.logger.warn((Object)("Node " + node.getId() + " set as unavailable"));
            }
        }
        if (previouslyAvailable = this.setAvailable(nodeStatus, false)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Node " + node.getId() + " now unavailable"));
            }
            for (FailureDetectorListener fdl : this.listeners.keySet()) {
                try {
                    fdl.nodeUnavailable(node);
                }
                catch (Exception ex) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) continue;
                    this.logger.warn((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    protected NodeStatus getNodeStatus(Node node) {
        NodeStatus nodeStatus = null;
        CompositeNodeStatus currentNodeStatus = this.idNodeStatusMap.get(node.getId());
        if (currentNodeStatus == null || !currentNodeStatus.getNode().isEqualState(node)) {
            if (this.logger.isEnabledFor((Priority)Level.WARN)) {
                this.logger.warn((Object)("creating new node status for node " + node.getId() + " for failure detector"));
            }
            if (currentNodeStatus != null) {
                this.idNodeStatusMap.remove(currentNodeStatus);
                this.failureDetectorConfig.removeNode(currentNodeStatus.getNode());
            }
            nodeStatus = this.createNodeStatus(this.failureDetectorConfig.getTime().getMilliseconds());
            this.idNodeStatusMap.put(node.getId(), new CompositeNodeStatus(node, nodeStatus));
            if (!this.failureDetectorConfig.getNodes().contains(node)) {
                this.failureDetectorConfig.addNode(node);
            }
        } else {
            nodeStatus = currentNodeStatus.getStatus();
        }
        return nodeStatus;
    }

    protected void checkNodeArg(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node must be non-null");
        }
    }

    protected void checkArgs(Node node, long requestTime) {
        this.checkNodeArg(node);
        if (requestTime < 0L) {
            throw new IllegalArgumentException("requestTime - " + requestTime + " - less than 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setAvailable(NodeStatus nodeStatus, boolean isAvailable) {
        NodeStatus nodeStatus2 = nodeStatus;
        synchronized (nodeStatus2) {
            boolean previous = nodeStatus.isAvailable();
            nodeStatus.setAvailable(isAvailable);
            nodeStatus.setLastChecked(this.getConfig().getTime().getMilliseconds());
            return previous;
        }
    }

    private class CompositeNodeStatus {
        private Node node;
        private NodeStatus status;

        CompositeNodeStatus(Node node, NodeStatus status) {
            this.node = node;
            this.status = status;
        }

        public void setValues(Node node, NodeStatus status) {
            this.node = node;
            this.status = status;
        }

        public Node getNode() {
            return this.node;
        }

        public NodeStatus getStatus() {
            return this.status;
        }
    }
}

