/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.protocol.admin.AsyncOperation;
import voldemort.server.protocol.admin.AsyncOperationCache;
import voldemort.server.protocol.admin.AsyncOperationStatus;
import voldemort.server.scheduler.SchedulerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="Asynchronous operation execution")
public class AsyncOperationService
extends AbstractService {
    private final Map<Integer, AsyncOperation> operations;
    private final AtomicInteger lastOperationId = new AtomicInteger(0);
    private final SchedulerService scheduler;
    private static final Logger logger = Logger.getLogger(AsyncOperationService.class);

    public AsyncOperationService(SchedulerService scheduler, int cacheSize) {
        super(ServiceType.ASYNC_SCHEDULER);
        this.operations = Collections.synchronizedMap(new AsyncOperationCache(cacheSize));
        this.scheduler = scheduler;
    }

    public synchronized void submitOperation(int requestId, AsyncOperation operation) {
        if (this.operations.containsKey(requestId)) {
            throw new VoldemortException("Request " + requestId + " already submitted to the system");
        }
        this.operations.put(requestId, operation);
        this.scheduler.scheduleNow(operation);
        logger.debug((Object)("Handling async operation " + requestId));
    }

    public synchronized boolean isComplete(int requestId) {
        if (!this.operations.containsKey(requestId)) {
            throw new VoldemortException("No operation with id " + requestId + " found");
        }
        if (this.operations.get(requestId).getStatus().isComplete()) {
            logger.debug((Object)("Operation complete " + requestId));
            this.operations.remove(requestId);
            return true;
        }
        return false;
    }

    @JmxOperation(description="Retrieve operation status")
    public String getStatus(int id) {
        try {
            return this.getOperationStatus(id).toString();
        }
        catch (VoldemortException e) {
            return "No operation with id " + id + " found";
        }
    }

    @JmxOperation(description="Retrieve all operations")
    public String getAllAsyncOperations() {
        String result;
        try {
            result = this.operations.toString();
        }
        catch (Exception e) {
            result = e.getMessage();
        }
        return result;
    }

    public List<Integer> getAsyncOperationList(boolean showCompleted) {
        ImmutableSet keySet = ImmutableSet.copyOf(this.operations.keySet());
        if (showCompleted) {
            return new ArrayList<Integer>((Collection<Integer>)keySet);
        }
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        Iterator i$ = keySet.iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            if (this.operations.get(key).getStatus().isComplete()) continue;
            keyList.add(key);
        }
        return keyList;
    }

    public AsyncOperationStatus getOperationStatus(int requestId) {
        if (!this.operations.containsKey(requestId)) {
            throw new VoldemortException("No operation with id " + requestId + " found");
        }
        return this.operations.get(requestId).getStatus();
    }

    @JmxOperation
    public String stopAsyncOperation(int requestId) {
        try {
            this.stopOperation(requestId);
        }
        catch (VoldemortException e) {
            return e.getMessage();
        }
        return "Stopping operation " + requestId;
    }

    public void stopOperation(int requestId) {
        if (!this.operations.containsKey(requestId)) {
            throw new VoldemortException("No operation with id " + requestId + " found");
        }
        this.operations.get(requestId).stop();
    }

    public int getUniqueRequestId() {
        return this.lastOperationId.getAndIncrement();
    }

    @Override
    protected void startInner() {
        logger.info((Object)"Starting asyncOperationRunner");
    }

    @Override
    protected void stopInner() {
        logger.info((Object)"Stopping asyncOperationRunner");
    }
}

