/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.http;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormat;
import voldemort.server.RequestRoutingType;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.utils.ByteArray;
import voldemort.utils.VoldemortIOUtils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStore
implements Store<ByteArray, byte[], byte[]> {
    private final String storeName;
    private final HttpClient httpClient;
    private final RequestFormat requestFormat;
    private final RequestRoutingType reroute;
    private final String storeUrl;

    public HttpStore(String storeName, String host, int port, HttpClient client, RequestFormat format, boolean reroute) {
        this.storeName = storeName;
        this.httpClient = client;
        this.requestFormat = format;
        this.reroute = RequestRoutingType.getRequestRoutingType(reroute, false);
        this.storeUrl = "http://" + host + ":" + port + "/stores";
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        boolean bl;
        StoreUtils.assertValidKey(key);
        DataInputStream input = null;
        try {
            HttpPost method = new HttpPost(this.storeUrl);
            ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
            this.requestFormat.writeDeleteRequest(new DataOutputStream(outputBytes), this.storeName, key, (VectorClock)version, this.reroute);
            input = this.executeRequest(method, outputBytes);
            bl = this.requestFormat.readDeleteResponse(input);
            Object var8_8 = null;
        }
        catch (IOException e) {
            try {
                throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return bl;
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        List<Versioned<byte[]>> list;
        StoreUtils.assertValidKey(key);
        DataInputStream input = null;
        try {
            HttpPost method = new HttpPost(this.storeUrl);
            ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
            this.requestFormat.writeGetRequest(new DataOutputStream(outputBytes), this.storeName, key, transforms, this.reroute);
            input = this.executeRequest(method, outputBytes);
            list = this.requestFormat.readGetResponse(input);
            Object var8_8 = null;
        }
        catch (IOException e) {
            try {
                throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return list;
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        Map<ByteArray, List<Versioned<byte[]>>> map;
        StoreUtils.assertValidKeys(keys);
        DataInputStream input = null;
        try {
            HttpPost method = new HttpPost(this.storeUrl);
            ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
            this.requestFormat.writeGetAllRequest(new DataOutputStream(outputBytes), this.storeName, keys, transforms, this.reroute);
            input = this.executeRequest(method, outputBytes);
            map = this.requestFormat.readGetAllResponse(input);
            Object var8_8 = null;
        }
        catch (IOException e) {
            try {
                throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return map;
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> versioned, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        DataInputStream input = null;
        try {
            try {
                HttpPost method = new HttpPost(this.storeUrl);
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                this.requestFormat.writePutRequest(new DataOutputStream(outputBytes), this.storeName, key, versioned.getValue(), transforms, (VectorClock)versioned.getVersion(), this.reroute);
                input = this.executeRequest(method, outputBytes);
                this.requestFormat.readPutResponse(input);
            }
            catch (IOException e) {
                throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    private DataInputStream executeRequest(HttpPost method, ByteArrayOutputStream output) {
        HttpResponse response = null;
        try {
            method.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            response = this.httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String message = response.getStatusLine().getReasonPhrase();
                VoldemortIOUtils.closeQuietly(response);
                throw new UnreachableStoreException("HTTP request to store " + this.storeName + " returned status code " + statusCode + " " + message);
            }
            return new DataInputStream(response.getEntity().getContent());
        }
        catch (IOException e) {
            VoldemortIOUtils.closeQuietly(response);
            throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return this.storeName;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        List<Version> list;
        StoreUtils.assertValidKey(key);
        DataInputStream input = null;
        try {
            HttpPost method = new HttpPost(this.storeUrl);
            ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
            this.requestFormat.writeGetVersionRequest(new DataOutputStream(outputBytes), this.storeName, key, this.reroute);
            input = this.executeRequest(method, outputBytes);
            list = this.requestFormat.readGetVersionResponse(input);
            Object var7_7 = null;
        }
        catch (IOException e) {
            try {
                throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return list;
    }
}

