/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.memory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import voldemort.VoldemortException;
import voldemort.annotations.concurrency.NotThreadsafe;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.StorageEngine;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Occurred;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryStorageEngine<K, V, T>
implements StorageEngine<K, V, T> {
    private final ConcurrentMap<K, List<Versioned<V>>> map;
    private final String name;

    public InMemoryStorageEngine(String name) {
        this.name = Utils.notNull(name);
        this.map = new ConcurrentHashMap<K, List<Versioned<V>>>();
    }

    public InMemoryStorageEngine(String name, ConcurrentMap<K, List<Versioned<V>>> map) {
        this.name = Utils.notNull(name);
        this.map = Utils.notNull(map);
    }

    @Override
    public void close() {
    }

    public void deleteAll() {
        this.map.clear();
    }

    public boolean delete(K key) {
        return this.delete(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(K key, Version version) {
        StoreUtils.assertValidKey(key);
        if (version == null) {
            return this.map.remove(key) != null;
        }
        List values = (List)this.map.get(key);
        if (values == null) {
            return false;
        }
        List list = values;
        synchronized (list) {
            boolean deletedSomething = false;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Versioned item = (Versioned)iterator.next();
                if (item.getVersion().compare(version) != Occurred.BEFORE) continue;
                iterator.remove();
                deletedSomething = true;
            }
            if (values.size() == 0 && !this.map.remove(key, values)) {
                return false;
            }
            return deletedSomething;
        }
    }

    @Override
    public List<Version> getVersions(K key) {
        return StoreUtils.getVersions(this.get(key, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Versioned<V>> get(K key, T transform) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        List results = (List)this.map.get(key);
        if (results == null) {
            return new ArrayList<Versioned<V>>(0);
        }
        List list = results;
        synchronized (list) {
            return new ArrayList<Versioned<V>>(results);
        }
    }

    @Override
    public Map<K, List<Versioned<V>>> getAll(Iterable<K> keys, Map<K, T> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        return StoreUtils.getAll(this, keys, transforms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, Versioned<V> value, T transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        Version version = value.getVersion();
        boolean success = false;
        while (!success) {
            ArrayList<Versioned<V>> items = (ArrayList<Versioned<V>>)this.map.get(key);
            if (items == null) {
                items = new ArrayList<Versioned<V>>();
                items.add(new Versioned<V>(value.getValue(), version));
                success = this.map.putIfAbsent(key, items) == null;
                continue;
            }
            ArrayList<Versioned<V>> arrayList = items;
            synchronized (arrayList) {
                if (this.map.get(key) != items) {
                    continue;
                }
                ArrayList<Versioned> itemsToRemove = new ArrayList<Versioned>(items.size());
                for (Versioned versioned : items) {
                    Occurred occurred = value.getVersion().compare(versioned.getVersion());
                    if (occurred == Occurred.BEFORE) {
                        throw new ObsoleteVersionException("Obsolete version for key '" + key + "': " + value.getVersion());
                    }
                    if (occurred != Occurred.AFTER) continue;
                    itemsToRemove.add(versioned);
                }
                items.removeAll(itemsToRemove);
                items.add(value);
            }
            success = true;
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public ClosableIterator<Pair<K, Versioned<V>>> entries() {
        return new InMemoryIterator<K, V>(this.map);
    }

    @Override
    public ClosableIterator<K> keys() {
        return StoreUtils.keys(this.entries());
    }

    @Override
    public void truncate() {
        this.map.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(15);
    }

    public String toString(int size) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int count = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            if (count > size) {
                builder.append("...");
                break;
            }
            builder.append(entry.getKey());
            builder.append(':');
            builder.append(entry.getValue());
            builder.append(',');
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public boolean isPartitionAware() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadsafe
    private static class InMemoryIterator<K, V>
    implements ClosableIterator<Pair<K, Versioned<V>>> {
        private final Iterator<Map.Entry<K, List<Versioned<V>>>> iterator;
        private K currentKey;
        private Iterator<Versioned<V>> currentValues;

        public InMemoryIterator(ConcurrentMap<K, List<Versioned<V>>> map) {
            this.iterator = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.hasNextInCurrentValues() || this.iterator.hasNext();
        }

        private boolean hasNextInCurrentValues() {
            return this.currentValues != null && this.currentValues.hasNext();
        }

        private Pair<K, Versioned<V>> nextInCurrentValues() {
            Versioned<V> item = this.currentValues.next();
            return Pair.create(this.currentKey, item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Pair<K, Versioned<V>> next() {
            if (this.hasNextInCurrentValues()) {
                return this.nextInCurrentValues();
            }
            while (true) {
                List<Versioned<V>> list;
                Map.Entry<K, List<Versioned<V>>> entry = this.iterator.next();
                List<Versioned<V>> list2 = list = entry.getValue();
                synchronized (list2) {
                    if (list.size() != 0) {
                        this.currentValues = new ArrayList<Versioned<V>>(list).iterator();
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                        this.currentKey = entry.getKey();
                        return this.nextInCurrentValues();
                    }
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("No removal y'all.");
        }

        @Override
        public void close() {
        }
    }
}

