/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterWideCounter {
    private static final Logger logger = Logger.getLogger(ClusterWideCounter.class);
    private final Cluster cluster;
    private final ConcurrentMap<Integer, AtomicLong> values;

    public ClusterWideCounter(Cluster cluster) {
        this.cluster = cluster;
        this.values = new ConcurrentHashMap<Integer, AtomicLong>(cluster.getNumberOfNodes());
        for (Node node : cluster.getNodes()) {
            this.values.put(node.getId(), new AtomicLong(0L));
        }
    }

    public void incrementCount(int nodeId) {
        AtomicLong counter = (AtomicLong)this.values.get(nodeId);
        if (counter == null) {
            counter = new AtomicLong(0L);
            this.values.putIfAbsent(nodeId, counter);
        }
        counter.incrementAndGet();
    }

    public void clearCount() {
        for (AtomicLong counter : this.values.values()) {
            counter.set(0L);
        }
    }

    public void clearCount(int nodeId) {
        AtomicLong counter = (AtomicLong)this.values.get(nodeId);
        if (counter == null) {
            counter = new AtomicLong(0L);
            this.values.put(nodeId, counter);
        } else {
            counter.set(0L);
        }
    }

    public void setCount(int nodeId, Long newValue) {
        AtomicLong counter = (AtomicLong)this.values.get(nodeId);
        if (counter == null) {
            counter = new AtomicLong(0L);
            this.values.putIfAbsent(nodeId, counter);
        }
        counter.set(newValue);
    }

    public void setAll(Map<Integer, Long> newValues) {
        for (Map.Entry<Integer, Long> entry : newValues.entrySet()) {
            this.setCount(entry.getKey(), entry.getValue());
        }
    }

    public Map<Integer, Long> asMap() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.values.size());
        for (Map.Entry entry : this.values.entrySet()) {
            map.put(entry.getKey(), ((AtomicLong)entry.getValue()).get());
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<Integer, Long> byZone() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.cluster.getNumberOfNodes());
        for (Map.Entry entry : this.values.entrySet()) {
            try {
                Node node = this.cluster.getNodeById((Integer)entry.getKey());
                int zoneId = node.getZoneId();
                Long count = (Long)map.get(zoneId);
                if (count == null) {
                    count = 0L;
                }
                count = count + ((AtomicLong)entry.getValue()).get();
                map.put(zoneId, count);
            }
            catch (VoldemortException e) {
                logger.warn((Object)("Can't get zone information for node id " + entry.getKey()), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public Long getCount(int nodeId) {
        AtomicLong counter = (AtomicLong)this.values.get(nodeId);
        if (counter == null) {
            throw new IllegalArgumentException("no value for " + nodeId);
        }
        return counter.get();
    }

    public Long getTotalCount() {
        long total = 0L;
        for (AtomicLong value : this.values.values()) {
            total += value.get();
        }
        return total;
    }
}

