/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class UnionOnSchemaSetter
extends LogicalRelationalNodesVisitor {
    public UnionOnSchemaSetter(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    public void visit(LOUnion union) throws FrontendException {
        if (!union.isOnSchema()) {
            return;
        }
        LogicalSchema outputSchema = union.getSchema();
        int fieldCount = outputSchema.size();
        OperatorPlan plan = union.getPlan();
        ArrayList<Operator> preds = new ArrayList<Operator>();
        preds.addAll(plan.getPredecessors(union));
        ArrayList<LogicalSchema> fieldSchemas = new ArrayList<LogicalSchema>(fieldCount);
        for (LogicalSchema.LogicalFieldSchema fs : outputSchema.getFields()) {
            LogicalSchema ls = new LogicalSchema();
            ls.addField(new LogicalSchema.LogicalFieldSchema(fs.alias, null, 1));
            fieldSchemas.add(ls);
        }
        for (Operator pred : preds) {
            LogicalRelationalOperator op = (LogicalRelationalOperator)pred;
            LogicalSchema opSchema = op.getSchema();
            if (opSchema.isEqual(outputSchema, true)) continue;
            LOForEach foreach = new LOForEach(plan);
            LogicalPlan innerPlan = new LogicalPlan();
            LOGenerate gen = new LOGenerate(innerPlan);
            boolean[] flattenFlags = new boolean[fieldCount];
            ArrayList<LogicalExpressionPlan> exprPlans = new ArrayList<LogicalExpressionPlan>(fieldCount);
            ArrayList<LOInnerLoad> genInputs = new ArrayList<LOInnerLoad>();
            for (LogicalSchema.LogicalFieldSchema logicalFieldSchema : outputSchema.getFields()) {
                LogicalExpressionPlan exprPlan = new LogicalExpressionPlan();
                exprPlans.add(exprPlan);
                int pos = -1;
                LogicalSchema.LogicalFieldSchema matchFS = opSchema.getFieldSubNameMatch(logicalFieldSchema.alias);
                if (matchFS != null) {
                    pos = opSchema.getFieldPosition(matchFS.alias);
                }
                if (pos == -1) {
                    ConstantExpression constExp = new ConstantExpression(exprPlan, null);
                    if (logicalFieldSchema.type == 50) continue;
                    LogicalSchema.LogicalFieldSchema constFs = logicalFieldSchema.deepCopy();
                    constFs.resetUid();
                    new CastExpression(exprPlan, constExp, constFs);
                    continue;
                }
                ProjectExpression projExpr = new ProjectExpression((OperatorPlan)exprPlan, genInputs.size(), 0, (LogicalRelationalOperator)gen);
                if (opSchema.getField((int)pos).type != logicalFieldSchema.type) {
                    new CastExpression(exprPlan, projExpr, logicalFieldSchema);
                }
                genInputs.add(new LOInnerLoad((OperatorPlan)innerPlan, foreach, pos));
            }
            gen.setFlattenFlags(flattenFlags);
            gen.setOutputPlans(exprPlans);
            gen.setUserDefinedSchema(fieldSchemas);
            innerPlan.add(gen);
            for (Operator operator : genInputs) {
                innerPlan.add(operator);
                innerPlan.connect(operator, gen);
            }
            foreach.setInnerPlan(innerPlan);
            foreach.setAlias(union.getAlias());
            Pair<Integer, Integer> pair = plan.disconnect(pred, union);
            plan.add(foreach);
            plan.connect(pred, (Integer)pair.first, foreach, 0);
            plan.connect(foreach, 0, union, (Integer)pair.second);
        }
        union.setUnionOnSchema(false);
    }
}

