/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.streams;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class StreamGenerator
implements ActionListener {
    JFrame generatorFrame;
    JPanel generatorPanel;
    JTextField fileField;
    JTextField formatField;
    JTextField numberField;
    JLabel fileLabel;
    JLabel formatLabel;
    JLabel numberLabel;
    JButton generateButton;
    PrintWriter out = null;
    int[] formats;
    Random random = new Random();

    public StreamGenerator() {
        this.generatorFrame = new JFrame("Stream Generator");
        this.generatorFrame.setDefaultCloseOperation(3);
        this.generatorFrame.setSize(new Dimension(120, 40));
        this.generatorPanel = new JPanel(new GridLayout(4, 4));
        this.addWidgets();
        this.generatorFrame.getRootPane().setDefaultButton(this.generateButton);
        this.generatorFrame.getContentPane().add((Component)this.generatorPanel, "Center");
        this.generatorFrame.pack();
        this.generatorFrame.setVisible(true);
    }

    private void addWidgets() {
        this.fileField = new JTextField(10);
        this.formatField = new JTextField(10);
        this.numberField = new JTextField(5);
        this.fileLabel = new JLabel("File", 2);
        this.generateButton = new JButton("Generate");
        this.formatLabel = new JLabel("Format", 2);
        this.numberLabel = new JLabel("Number of tuples", 2);
        this.generateButton.addActionListener(this);
        this.generatorPanel.add(this.fileLabel);
        this.generatorPanel.add(this.fileField);
        this.generatorPanel.add(this.formatLabel);
        this.generatorPanel.add(this.formatField);
        this.generatorPanel.add(this.numberLabel);
        this.generatorPanel.add(this.numberField);
        this.generatorPanel.add(this.generateButton);
        this.fileLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.formatLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void actionPerformed(ActionEvent event) {
        if (this.out == null) {
            try {
                String fileName = this.fileField.getText();
                String format = this.formatField.getText();
                this.out = new PrintWriter(fileName);
                String[] formats = format.split(",");
                this.formats = new int[formats.length];
                for (int i = 0; i < formats.length; ++i) {
                    this.formats[i] = (int)Math.pow(10.0, Integer.parseInt(formats[i]));
                }
            }
            catch (Exception e) {
                new Dialog((Frame)this.generatorFrame, "Input not well formed");
            }
            this.fileField.setEditable(false);
            this.formatField.setEditable(false);
        }
        int numTuples = 0;
        try {
            numTuples = Integer.parseInt(this.numberField.getText());
        }
        catch (Exception e) {
            new Dialog((Frame)this.generatorFrame, "Input not well formed");
        }
        for (int i = 0; i < numTuples; ++i) {
            for (int j = 0; j < this.formats.length; ++j) {
                this.out.print(this.random.nextInt(this.formats[j]));
                if (j == this.formats.length - 1) {
                    this.out.println("");
                    continue;
                }
                this.out.print("\t");
            }
        }
        this.out.flush();
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StreamGenerator.createAndShowGUI();
            }
        });
    }
}

