/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class Utils {
    public static final Random RANDOM = new Random();

    private Utils() {
    }

    public static boolean equals(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public static <T> T nonNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        return t;
    }

    public static void croak(String message, int exitCode) {
        System.err.println(message);
        System.exit(exitCode);
    }

    public static File createTempDir() {
        return Utils.createTempDir(new File(System.getProperty("java.io.tmpdir")));
    }

    public static File createTempDir(File parent) {
        File temp = new File(parent, Integer.toString(Math.abs(RANDOM.nextInt()) % 100000000));
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        return temp;
    }

    public static void zip(File input, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        ZipOutputStream zOut = new ZipOutputStream(out);
        Utils.zipFile("", input, zOut);
        zOut.close();
    }

    private static void zipFile(String path, File input, ZipOutputStream zOut) throws IOException {
        if (input.isDirectory()) {
            File[] files = input.listFiles();
            if (files != null) {
                for (File f : files) {
                    String childPath = path + input.getName() + (f.isDirectory() ? "/" : "");
                    Utils.zipFile(childPath, f, zOut);
                }
            }
        } else {
            String childPath = path + (path.length() > 0 ? "/" : "") + input.getName();
            ZipEntry entry = new ZipEntry(childPath);
            zOut.putNextEntry(entry);
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(input));
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zOut);
            ((InputStream)fileInputStream).close();
        }
    }

    public static void unzip(ZipFile source, File dest) throws IOException {
        Enumeration<? extends ZipEntry> entries = source.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File newFile = new File(dest, entry.getName());
            if (entry.isDirectory()) {
                newFile.mkdirs();
                continue;
            }
            newFile.getParentFile().mkdirs();
            InputStream src = source.getInputStream(entry);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(newFile));
            IOUtils.copy((InputStream)src, (OutputStream)output);
            src.close();
            ((OutputStream)output).close();
        }
    }

    public static String flattenToString(Collection<?> collection, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (Object obj : collection) {
            buffer.append(obj.toString());
            buffer.append(',');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static Double convertToDouble(Object obj) {
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        return (Double)obj;
    }

    private static RuntimeException getCause(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new IllegalStateException(e.getCause());
    }

    public static Class<?>[] getTypes(Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return argTypes;
    }

    public static Object callConstructor(Class<?> c, Object ... args) {
        return Utils.callConstructor(c, Utils.getTypes(args), args);
    }

    public static Object callConstructor(Class<?> c, Class<?>[] argTypes, Object[] args) {
        try {
            Constructor<?> cons = c.getConstructor(argTypes);
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw Utils.getCause(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String formatDuration(long startTime, long endTime) {
        if (startTime == -1L) {
            return "-";
        }
        long durationMS = endTime == -1L ? System.currentTimeMillis() - startTime : endTime - startTime;
        long seconds = durationMS / 1000L;
        if (seconds < 60L) {
            return seconds + " sec";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes < 60L) {
            return minutes + "m " + seconds + "s";
        }
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours < 24L) {
            return hours + "h " + minutes + "m " + seconds + "s";
        }
        long days = hours / 24L;
        return days + "d " + (hours %= 24L) + "h " + minutes + "m";
    }

    public static Object invokeStaticMethod(ClassLoader loader, String className, String methodName, Object ... args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = loader.loadClass(className);
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Method method = clazz.getDeclaredMethod(methodName, argTypes);
        return method.invoke(null, args);
    }
}

